/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextArea;
import ir.deepmine.dictation.Main;
import ir.deepmine.dictation.database.Document;
import ir.deepmine.dictation.ui.ClosableTag;
import ir.deepmine.dictation.utils.Utilities;
import ir.huri.jcal.JalaliCalendar;
import java.util.ArrayList;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;

public class CustomDocument
extends AnchorPane {
    private static final Tooltip editTooltip = new Tooltip("\u0648\u06cc\u0631\u0627\u06cc\u0634");
    private static final Tooltip eyeTooltip = new Tooltip("\u0645\u0634\u0627\u0647\u062f\u0647");
    private static final Tooltip deleteTooltip = new Tooltip("\u062d\u0630\u0641 \u0645\u0648\u0642\u062a");
    private static final Tooltip archiveTooltip = new Tooltip("\u0628\u0627\u06cc\u06af\u0627\u0646\u06cc \u0633\u0646\u062f");
    private static final Tooltip unArchiveTooltip = new Tooltip("\u062e\u0631\u0648\u062c \u0627\u0632 \u0628\u0627\u06cc\u06af\u0627\u0646\u06cc");
    private static final Tooltip reStoreTooltip = new Tooltip("\u0630\u062e\u06cc\u0631\u0647 \u0645\u062c\u062f\u062f");
    private static final Tooltip deleteForeverTooltip = new Tooltip("\u062d\u0630\u0641 \u062f\u0627\u0626\u0645");
    private static final Image pen = new Image(String.valueOf(Main.class.getResource("/icons/edit.png")));
    private static final Image trash = new Image(String.valueOf(Main.class.getResource("/icons/delete.png")));
    private static final Image arch = new Image(String.valueOf(Main.class.getResource("/icons/archive1.png")));
    private static final Image eye = new Image(String.valueOf(Main.class.getResource("/icons/visibility.png")));
    private static final Image deleteForever = new Image(String.valueOf(Main.class.getResource("/icons/deleteForever2.png")));
    private static final Image unTrash = new Image(String.valueOf(Main.class.getResource("/icons/restoreFromTrash5.png")));
    private static final Image unArch = new Image(String.valueOf(Main.class.getResource("/icons/unarchive.png")));
    private final ImageView deleteOrDeleteForeverImage;
    private final ImageView archiveOrUnArchiveOrUnDeleteImage;
    private final ImageView editOrViewImage;
    private final FlowPane tagsBase;
    private final ScrollPane scrollPane;
    private final Document document;
    private final ArrayList<ClosableTag> tags;
    private JalaliCalendar generateDate;
    private JalaliCalendar modifyDate;
    private Label nameLabel;
    private Label modifyDateLabel;
    private String name;
    private String text;
    private Label generateDateLabel;
    private JFXTextArea textArea;
    private JFXButton editOrView;
    private JFXButton deleteOrDeleteForever;
    private JFXButton archiveOrUnArchiveOrUnDelete;
    private ImageView calendar;
    private ImageView reModify;
    private boolean isModify;
    private boolean isBig;
    private ScrollPane textAreaScrollPane;
    private boolean inTag;
    private boolean deleteFromPage = false;
    private String fontDate = "Vazir";

    public CustomDocument(Document document) {
        this.document = document;
        this.name = document.getTitle();
        this.nameLabel = new Label(this.name);
        this.text = document.getPureContent();
        this.generateDate = new JalaliCalendar(document.getCreation_date());
        this.modifyDate = new JalaliCalendar(document.getUpdated_at());
        this.textArea = new JFXTextArea();
        if (this.text.length() > 500) {
            this.textArea.setText(this.text.substring(0, 500) + "...");
        } else {
            this.textArea.setText(this.text);
        }
        this.isModify = !document.getCreation_date().toString().equalsIgnoreCase(document.getUpdated_at().toString());
        this.tags = new ArrayList();
        for (int i = 0; i < document.getLabels().size(); ++i) {
            this.tags.add(new ClosableTag(document.getLabels().get(i)));
        }
        this.isBig = false;
        this.tagsBase = new FlowPane();
        this.scrollPane = new ScrollPane();
        this.textAreaScrollPane = new ScrollPane();
        this.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        this.tagsBase.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
        this.scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.textAreaScrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.textAreaScrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.scrollPane.setContent((Node)this.tagsBase);
        this.textArea.setEditable(false);
        this.textArea.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
        this.nameLabel.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
        this.nameLabel.setTextAlignment(TextAlignment.RIGHT);
        this.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        this.scrollPane.viewportBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
                CustomDocument.this.tagsBase.setPrefWidth(newValue.getWidth());
                CustomDocument.this.tagsBase.setPrefHeight(newValue.getHeight());
            }
        });
        editTooltip.setShowDelay(Duration.millis((double)500.0));
        eyeTooltip.setShowDelay(Duration.millis((double)500.0));
        deleteTooltip.setShowDelay(Duration.millis((double)500.0));
        archiveTooltip.setShowDelay(Duration.millis((double)500.0));
        unArchiveTooltip.setShowDelay(Duration.millis((double)500.0));
        reStoreTooltip.setShowDelay(Duration.millis((double)500.0));
        unArchiveTooltip.setShowDelay(Duration.millis((double)500.0));
        deleteForeverTooltip.setShowDelay(Duration.millis((double)500.0));
        this.modifyDateLabel = new Label(this.makeDate(this.modifyDate));
        this.generateDateLabel = new Label(this.makeDate(this.generateDate));
        this.editOrViewImage = new ImageView(pen);
        this.deleteOrDeleteForeverImage = new ImageView(trash);
        this.archiveOrUnArchiveOrUnDeleteImage = new ImageView(arch);
        this.calendar = new ImageView(new Image(String.valueOf(Main.class.getResource("/icons/calendar.png"))));
        this.reModify = new ImageView(new Image(String.valueOf(Main.class.getResource("/icons/update.png"))));
        this.getStylesheets().add((Object)String.valueOf(Main.class.getResource("/style/document.css")));
        this.scrollPane.getStylesheets().add((Object)String.valueOf(Main.class.getResource("/style/scroll.css")));
        this.editOrView = new JFXButton();
        this.deleteOrDeleteForever = new JFXButton();
        this.archiveOrUnArchiveOrUnDelete = new JFXButton();
        this.editOrView.setGraphic((Node)this.editOrViewImage);
        this.deleteOrDeleteForever.setGraphic((Node)this.deleteOrDeleteForeverImage);
        this.archiveOrUnArchiveOrUnDelete.setGraphic((Node)this.archiveOrUnArchiveOrUnDeleteImage);
        this.editOrView.setRipplerFill((Paint)Color.valueOf((String)"#262525"));
        this.deleteOrDeleteForever.setRipplerFill((Paint)Color.valueOf((String)"#262525"));
        this.archiveOrUnArchiveOrUnDelete.setRipplerFill((Paint)Color.valueOf((String)"#262525"));
        this.scrollPane.setStyle("-fx-font-size: 40px;");
        this.tagsBase.setStyle("-fx-font-size: 11px;");
        this.editOrView.setStyle("-fx-padding: -4px -4px -4px -3px;-fx-border-insets: -4px;-fx-background-insets: -4px -4px -4px -3px;");
        this.deleteOrDeleteForever.setStyle("-fx-padding: -4px;-fx-border-insets: -4px;-fx-background-insets: -3px;");
        this.archiveOrUnArchiveOrUnDelete.setStyle("-fx-padding: 0px;-fx-border-insets: 0px;-fx-background-insets: 0px;");
        this.getChildren().addAll((Object[])new Node[]{this.scrollPane, this.nameLabel, this.modifyDateLabel, this.generateDateLabel, this.textArea, this.editOrView, this.deleteOrDeleteForever, this.calendar, this.reModify, this.archiveOrUnArchiveOrUnDelete});
        this.normalInitialize();
        this.setActions();
    }

    public void makeNormal() {
        this.generateDateLabel.setVisible(false);
        this.isBig = false;
        this.normalInitialize();
    }

    public void makeBig() {
        this.generateDateLabel.setVisible(true);
        this.isBig = true;
        this.bigInitialize();
    }

    public String makeDate(JalaliCalendar date) {
        String day = Utilities.normalizeDigits(String.valueOf(date.getDay()));
        String month = Utilities.normalizeDigits(String.valueOf(date.getMonth()));
        String year = Utilities.normalizeDigits(String.valueOf(date.getYear()));
        return year.substring(2, 4) + "/" + month + "/" + day;
    }

    private void setActions() {
        final DropShadow deleteShadow = new DropShadow();
        deleteShadow.setColor((Color)Paint.valueOf((String)"#ff8a80"));
        deleteShadow.setRadius(3.0);
        final DropShadow editShadow = new DropShadow();
        editShadow.setColor((Color)Paint.valueOf((String)"#fff59d"));
        editShadow.setRadius(3.0);
        final DropShadow archiveShadow = new DropShadow();
        archiveShadow.setColor((Color)Paint.valueOf((String)"#ffd54f"));
        archiveShadow.setRadius(3.0);
        super.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (CustomDocument.this.isBig) {
                    CustomDocument.super.setStyle("-fx-background-color:#262525;-fx-border-radius:8px;-fx-background-radius:8px;-fx-border-color:#3E3B3B;");
                } else {
                    CustomDocument.super.setStyle("-fx-background-color:#262525;-fx-border-radius:4px;-fx-background-radius:4px;-fx-border-color:#3E3B3B;");
                }
                if (CustomDocument.this.isBig) {
                    CustomDocument.this.textArea.setStyle("-fx-background-color: #262525;-fx-background-padding:10px;-fx-text-fill : #e4e4e4;");
                } else {
                    CustomDocument.this.textArea.setStyle("-fx-background-color: #262525;-fx-text-fill : #e4e4e4;-fx-background-padding:10px;");
                }
                CustomDocument.this.textArea.setFocusColor(Paint.valueOf((String)"#262525"));
                CustomDocument.this.textArea.setUnFocusColor(Paint.valueOf((String)"#262525"));
                CustomDocument.this.tagsBase.setStyle("-fx-padding: 4px;-fx-background-color:#262525;-fx-font-size: 10px;");
                CustomDocument.this.scrollPane.setStyle("-fx-background-color:#262525;-fx-padding:8px 8px 8px 5px;-fx-font-size: 10px;");
                CustomDocument.this.deleteOrDeleteForever.setVisible(true);
                CustomDocument.this.editOrView.setVisible(true);
                CustomDocument.this.archiveOrUnArchiveOrUnDelete.setVisible(true);
            }
        });
        super.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (CustomDocument.this.isBig) {
                    CustomDocument.super.setStyle("-fx-background-color:#121212;-fx-border-radius:8px;-fx-background-radius:8px;-fx-border-color:#3E3B3B;");
                } else {
                    CustomDocument.super.setStyle("-fx-background-color:#121212;-fx-border-radius:4px;-fx-background-radius: 4px;-fx-border-color:#3E3B3B;");
                }
                if (CustomDocument.this.isBig) {
                    CustomDocument.this.textArea.setStyle("-fx-text-fill:#e4e4e4;-fx-background-color : #121212;-fx-background-padding:10px 10px 10px 10px;");
                } else {
                    CustomDocument.this.textArea.setStyle("-fx-text-fill : #e4e4e4;-fx-background-color: #121212;-fx-background-padding:10px 10px 10px 10px;");
                }
                CustomDocument.this.textArea.setFocusColor(Paint.valueOf((String)"#121212"));
                CustomDocument.this.textArea.setUnFocusColor(Paint.valueOf((String)"#121212"));
                CustomDocument.this.tagsBase.setStyle("-fx-padding: 4px 4px 4px 4px;-fx-background-color:#121212;-fx-font-size: 11px;");
                CustomDocument.this.scrollPane.setStyle("-fx-background-color:#121212;-fx-padding:8px 8px 8px 5px;-fx-font-size: 11px;");
                if (!CustomDocument.this.isBig) {
                    CustomDocument.this.deleteOrDeleteForever.setVisible(false);
                    CustomDocument.this.editOrView.setVisible(false);
                    CustomDocument.this.archiveOrUnArchiveOrUnDelete.setVisible(false);
                }
            }
        });
        this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                CustomDocument.this.tagsBase.setStyle("-fx-padding: 4px 4px 4px 32px;-fx-background-color: #262525;-fx-font-size: 11px;");
                CustomDocument.this.scrollPane.setStyle("-fx-background-color:#262525;-fx-padding:8px 8px 8px 5px;-fx-font-size: 40px;");
                if (CustomDocument.this.canBig()) {
                    if (!CustomDocument.this.isBig) {
                        CustomDocument.this.generateDateLabel.setVisible(true);
                        CustomDocument.this.isBig = true;
                        CustomDocument.this.bigInitialize();
                    } else {
                        CustomDocument.this.generateDateLabel.setVisible(false);
                        CustomDocument.this.isBig = false;
                        CustomDocument.this.normalInitialize();
                    }
                }
            }
        });
        this.textArea.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                CustomDocument.this.tagsBase.setStyle("-fx-padding: 4px 4px 4px 32px;-fx-background-color: #262525;-fx-font-size: 10px;");
                CustomDocument.this.scrollPane.setStyle("-fx-background-color:#262525;-fx-padding:8px 8px 8px 5px;-fx-font-size: 10px;");
                if (CustomDocument.this.canBig()) {
                    if (!CustomDocument.this.isBig) {
                        CustomDocument.this.generateDateLabel.setVisible(true);
                        CustomDocument.this.isBig = true;
                        CustomDocument.this.bigInitialize();
                    } else {
                        CustomDocument.this.generateDateLabel.setVisible(false);
                        CustomDocument.this.isBig = false;
                        CustomDocument.this.normalInitialize();
                    }
                }
            }
        });
        this.editOrView.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                CustomDocument.this.editOrView.setEffect((Effect)editShadow);
            }
        });
        this.editOrView.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                CustomDocument.this.editOrView.setEffect(null);
            }
        });
        this.deleteOrDeleteForever.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                CustomDocument.this.deleteOrDeleteForever.setEffect((Effect)deleteShadow);
            }
        });
        this.deleteOrDeleteForever.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                CustomDocument.this.deleteOrDeleteForever.setEffect(null);
            }
        });
        this.archiveOrUnArchiveOrUnDelete.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                CustomDocument.this.archiveOrUnArchiveOrUnDelete.setEffect((Effect)archiveShadow);
            }
        });
        this.archiveOrUnArchiveOrUnDelete.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                CustomDocument.this.archiveOrUnArchiveOrUnDelete.setEffect(null);
            }
        });
        this.scrollPane.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                CustomDocument.this.scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
            }
        });
        this.scrollPane.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                CustomDocument.this.scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
            }
        });
    }

    public boolean canBig() {
        if (this.editOrView.getEffect() == null && this.deleteOrDeleteForever.getEffect() == null && this.archiveOrUnArchiveOrUnDelete.getEffect() == null) {
            return this.scrollPane.getVbarPolicy() == ScrollPane.ScrollBarPolicy.NEVER;
        }
        return false;
    }

    private void putTags() {
        for (int i = 0; i < this.document.getLabels().size(); ++i) {
            ClosableTag closableTag = new ClosableTag(this.document.getLabels().get(i));
            closableTag.setInDoc(true);
            this.tagsBase.getChildren().add((Object)closableTag);
        }
    }

    public void bigInitialize() {
        this.setMaxHeight(340.0);
        this.setMaxWidth(296.0);
        this.setPrefHeight(340.0);
        this.setPrefWidth(296.0);
        this.putNameLabel();
        this.nameLabel.setMaxWidth(250.0);
        this.textArea.setPrefHeight(175.0);
        this.textArea.setMaxWidth(264.0);
        this.textArea.setPrefWidth(264.0);
        this.textArea.setMinHeight(175.0);
        this.textArea.setMaxHeight(175.0);
        this.calendar.setFitHeight(14.0);
        this.calendar.setFitWidth(14.0);
        this.reModify.setFitWidth(14.0);
        this.reModify.setFitHeight(14.0);
        this.tagsBase.setHgap(4.0);
        this.tagsBase.setVgap(7.0);
        this.scrollPane.setPrefHeight(78.0);
        this.scrollPane.setPrefWidth(290.0);
        this.tagsBase.setStyle("-fx-padding: 4px 4px 4px 4px;-fx-background-color:#262525;");
        this.scrollPane.setStyle("-fx-background-color:#262525;-fx-padding:0px 8px 0px 5px;");
        this.textArea.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.MEDIUM, (double)12.0));
        this.generateDateLabel.setVisible(true);
        this.generateDateLabel.setStyle("-fx-background-blur:12px");
        this.nameLabel.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.BOLD, (double)16.0));
        this.generateDateLabel.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.BLACK, (double)12.0));
        this.modifyDateLabel.setVisible(true);
        this.modifyDateLabel.setStyle("-fx-background-blur:12px");
        this.modifyDateLabel.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.BLACK, (double)12.0));
        AnchorPane.setRightAnchor((Node)this.textArea, (Double)16.0);
        AnchorPane.setTopAnchor((Node)this.textArea, (Double)112.0);
        AnchorPane.setLeftAnchor((Node)this.generateDateLabel, (Double)242.0);
        AnchorPane.setLeftAnchor((Node)this.calendar, (Double)223.6);
        this.reModify.setLayoutY(311.0);
        this.reModify.setLayoutX(16.0);
        AnchorPane.setTopAnchor((Node)this.scrollPane, (Double)45.0);
        AnchorPane.setLeftAnchor((Node)this.scrollPane, (Double)2.0);
        this.setIcons();
        if (this.tags.size() != 0) {
            this.putTags();
            this.scrollPane.setVisible(true);
        } else {
            AnchorPane.setTopAnchor((Node)this.textArea, (Double)45.0);
            this.textArea.setMinHeight(250.0);
            this.textArea.setMaxHeight(250.0);
            this.textArea.setPrefHeight(250.0);
            this.scrollPane.setVisible(false);
        }
        this.reModify.setVisible(true);
        this.calendar.setVisible(true);
    }

    public void normalInitialize() {
        this.scrollPane.setVisible(false);
        this.setMaxHeight(180.0);
        this.setMaxWidth(160.0);
        this.setPrefHeight(180.0);
        this.setPrefWidth(160.0);
        this.setMinHeight(180.0);
        this.setMinWidth(160.0);
        this.tagsBase.getChildren().clear();
        super.setStyle("-fx-background-color: #121212;-fx-border-color: #3E3B3B;-fx-background-radius: 4px;-fx-border-radius: 4px;");
        if (!this.isModify) {
            this.reModify.setVisible(false);
            this.calendar.setVisible(true);
            this.generateDateLabel.setVisible(true);
            this.modifyDateLabel.setVisible(false);
            this.generateDateLabel.setPrefHeight(15.0);
            this.generateDateLabel.setPrefWidth(65.0);
            this.generateDateLabel.setStyle("-fx-background-blur:10px");
            this.generateDateLabel.setTextFill(Paint.valueOf((String)"#56564f"));
            this.generateDateLabel.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.BOLD, (double)12.0));
        } else {
            this.reModify.setVisible(true);
            this.calendar.setVisible(false);
            this.generateDateLabel.setVisible(false);
            this.modifyDateLabel.setVisible(true);
            this.modifyDateLabel.setPrefHeight(15.0);
            this.modifyDateLabel.setPrefWidth(65.0);
            this.modifyDateLabel.setTextFill(Paint.valueOf((String)"#56564f"));
            this.modifyDateLabel.setStyle("-fx-background-blur:10px");
            this.modifyDateLabel.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.BOLD, (double)12.0));
        }
        this.putNameLabel();
        this.nameLabel.setMaxWidth(100.0);
        this.textArea.setPrefHeight(116.0);
        this.textArea.setPrefWidth(120.0);
        this.textArea.setMinHeight(116.0);
        this.textArea.setMaxWidth(120.0);
        this.modifyDateLabel.setPrefHeight(15.0);
        this.modifyDateLabel.setPrefWidth(65.0);
        this.generateDateLabel.setPrefHeight(15.0);
        this.generateDateLabel.setPrefWidth(65.0);
        this.reModify.setFitWidth(14.0);
        this.reModify.setFitHeight(14.0);
        this.calendar.setFitHeight(14.0);
        this.calendar.setFitWidth(14.0);
        this.nameLabel.setStyle("-fx-text-fill: #fff59d;");
        this.nameLabel.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.EXTRA_BOLD, (double)16.0));
        this.textArea.setStyle("-fx-text-fill : #e4e4e4;-fx-background-color: #121212;-fx-background-padding:10px 10px 10px 10px;-fx-background-margin:10px;");
        this.textArea.setFocusColor(Paint.valueOf((String)"#121212"));
        this.textArea.setUnFocusColor(Paint.valueOf((String)"#121212"));
        this.textArea.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.SEMI_BOLD, (double)12.0));
        this.modifyDateLabel.setTextFill(Paint.valueOf((String)"#56564f"));
        this.modifyDateLabel.setStyle("-fx-background-blur:10px");
        this.generateDateLabel.setStyle("-fx-background-blur:10px");
        this.generateDateLabel.setTextFill(Paint.valueOf((String)"#56564f"));
        AnchorPane.setLeftAnchor((Node)this.generateDateLabel, (Double)33.0);
        AnchorPane.setBottomAnchor((Node)this.generateDateLabel, (Double)9.0);
        AnchorPane.setLeftAnchor((Node)this.modifyDateLabel, (Double)33.0);
        AnchorPane.setBottomAnchor((Node)this.modifyDateLabel, (Double)9.0);
        AnchorPane.setLeftAnchor((Node)this.reModify, (Double)15.0);
        AnchorPane.setBottomAnchor((Node)this.reModify, (Double)11.0);
        AnchorPane.setLeftAnchor((Node)this.calendar, (Double)15.0);
        AnchorPane.setBottomAnchor((Node)this.calendar, (Double)11.0);
        AnchorPane.setRightAnchor((Node)this.textArea, (Double)16.0);
        AnchorPane.setTopAnchor((Node)this.textArea, (Double)30.0);
        this.deleteOrDeleteForever.setVisible(false);
        this.editOrView.setVisible(false);
        this.archiveOrUnArchiveOrUnDelete.setVisible(false);
        this.setIcons();
    }

    private void putNameLabel() {
        if (!this.isBig) {
            AnchorPane.setTopAnchor((Node)this.nameLabel, (Double)1.0);
        } else {
            AnchorPane.setTopAnchor((Node)this.nameLabel, (Double)13.0);
        }
        AnchorPane.setRightAnchor((Node)this.nameLabel, (Double)20.0);
    }

    private void setIcons() {
        if (this.document.getDeletion_status() == 1) {
            this.editOrView.setTooltip(eyeTooltip);
            this.editOrView.getTooltip().setFont(Font.font((String)this.fontDate, (FontWeight)FontWeight.BLACK, (double)10.0));
            this.archiveOrUnArchiveOrUnDelete.setTooltip(unArchiveTooltip);
            this.archiveOrUnArchiveOrUnDelete.getTooltip().setFont(Font.font((String)this.fontDate, (FontWeight)FontWeight.BLACK, (double)10.0));
            this.deleteOrDeleteForever.setTooltip(deleteTooltip);
            this.deleteOrDeleteForever.getTooltip().setFont(Font.font((String)this.fontDate, (FontWeight)FontWeight.BLACK, (double)10.0));
            this.editOrViewImage.setImage(eye);
            this.archiveOrUnArchiveOrUnDeleteImage.setImage(unArch);
            this.deleteOrDeleteForeverImage.setImage(trash);
            this.archiveOrUnArchiveOrUnDeleteImage.setFitWidth(20.0);
            this.archiveOrUnArchiveOrUnDeleteImage.setFitHeight(20.0);
            this.editOrViewImage.setFitHeight(20.0);
            this.editOrViewImage.setFitWidth(20.0);
            this.deleteOrDeleteForeverImage.setFitHeight(22.0);
            this.deleteOrDeleteForeverImage.setFitWidth(24.0);
            if (!this.isBig) {
                AnchorPane.setRightAnchor((Node)this.deleteOrDeleteForever, (Double)37.0);
                AnchorPane.setBottomAnchor((Node)this.deleteOrDeleteForever, (Double)12.0);
                AnchorPane.setRightAnchor((Node)this.editOrView, (Double)12.0);
                AnchorPane.setBottomAnchor((Node)this.editOrView, (Double)12.0);
                AnchorPane.setRightAnchor((Node)this.archiveOrUnArchiveOrUnDelete, (Double)58.0);
                AnchorPane.setBottomAnchor((Node)this.archiveOrUnArchiveOrUnDelete, (Double)9.0);
            } else {
                this.archiveOrUnArchiveOrUnDeleteImage.setFitHeight(20.0);
                this.archiveOrUnArchiveOrUnDeleteImage.setFitHeight(20.0);
                AnchorPane.setRightAnchor((Node)this.deleteOrDeleteForever, (Double)230.0);
                AnchorPane.setBottomAnchor((Node)this.deleteOrDeleteForever, (Double)308.0);
                AnchorPane.setRightAnchor((Node)this.editOrView, (Double)195.0);
                AnchorPane.setBottomAnchor((Node)this.editOrView, (Double)308.0);
                AnchorPane.setRightAnchor((Node)this.archiveOrUnArchiveOrUnDelete, (Double)264.0);
                AnchorPane.setBottomAnchor((Node)this.archiveOrUnArchiveOrUnDelete, (Double)305.0);
            }
        } else if (this.document.getDeletion_status() == 2) {
            this.editOrView.setTooltip(eyeTooltip);
            this.editOrView.getTooltip().setFont(Font.font((String)this.fontDate, (FontWeight)FontWeight.BLACK, (double)10.0));
            this.archiveOrUnArchiveOrUnDelete.setTooltip(reStoreTooltip);
            this.archiveOrUnArchiveOrUnDelete.getTooltip().setFont(Font.font((String)this.fontDate, (FontWeight)FontWeight.BOLD, (double)10.0));
            this.deleteOrDeleteForever.setTooltip(deleteForeverTooltip);
            this.deleteOrDeleteForever.getTooltip().setFont(Font.font((String)this.fontDate, (FontWeight)FontWeight.BLACK, (double)10.0));
            this.editOrViewImage.setImage(eye);
            this.deleteOrDeleteForeverImage.setImage(deleteForever);
            this.archiveOrUnArchiveOrUnDeleteImage.setImage(unTrash);
            this.editOrViewImage.setFitHeight(20.0);
            this.editOrViewImage.setFitWidth(20.0);
            this.deleteOrDeleteForeverImage.setFitHeight(22.0);
            this.deleteOrDeleteForeverImage.setFitWidth(22.0);
            this.archiveOrUnArchiveOrUnDeleteImage.setFitWidth(19.0);
            this.archiveOrUnArchiveOrUnDeleteImage.setFitHeight(22.0);
            if (!this.isBig) {
                AnchorPane.setRightAnchor((Node)this.deleteOrDeleteForever, (Double)37.0);
                AnchorPane.setBottomAnchor((Node)this.deleteOrDeleteForever, (Double)12.0);
                AnchorPane.setRightAnchor((Node)this.editOrView, (Double)14.0);
                AnchorPane.setBottomAnchor((Node)this.editOrView, (Double)12.0);
                AnchorPane.setRightAnchor((Node)this.archiveOrUnArchiveOrUnDelete, (Double)58.0);
                AnchorPane.setBottomAnchor((Node)this.archiveOrUnArchiveOrUnDelete, (Double)8.0);
            } else {
                this.archiveOrUnArchiveOrUnDeleteImage.setFitHeight(20.0);
                this.archiveOrUnArchiveOrUnDeleteImage.setFitHeight(20.0);
                AnchorPane.setRightAnchor((Node)this.deleteOrDeleteForever, (Double)230.0);
                AnchorPane.setBottomAnchor((Node)this.deleteOrDeleteForever, (Double)308.0);
                AnchorPane.setRightAnchor((Node)this.editOrView, (Double)195.0);
                AnchorPane.setBottomAnchor((Node)this.editOrView, (Double)308.0);
                AnchorPane.setRightAnchor((Node)this.archiveOrUnArchiveOrUnDelete, (Double)264.0);
                AnchorPane.setBottomAnchor((Node)this.archiveOrUnArchiveOrUnDelete, (Double)305.0);
            }
        } else if (this.document.getDeletion_status() == 0) {
            this.editOrView.setTooltip(editTooltip);
            this.editOrView.getTooltip().setFont(Font.font((String)this.fontDate, (FontWeight)FontWeight.BLACK, (double)10.0));
            this.archiveOrUnArchiveOrUnDelete.setTooltip(archiveTooltip);
            this.archiveOrUnArchiveOrUnDelete.getTooltip().setFont(Font.font((String)this.fontDate, (FontWeight)FontWeight.BLACK, (double)10.0));
            this.deleteOrDeleteForever.setTooltip(deleteTooltip);
            this.deleteOrDeleteForever.getTooltip().setFont(Font.font((String)this.fontDate, (FontWeight)FontWeight.BLACK, (double)10.0));
            this.editOrViewImage.setImage(pen);
            this.archiveOrUnArchiveOrUnDeleteImage.setImage(arch);
            this.deleteOrDeleteForeverImage.setImage(trash);
            this.archiveOrUnArchiveOrUnDeleteImage.setFitHeight(19.0);
            this.archiveOrUnArchiveOrUnDeleteImage.setFitWidth(21.0);
            this.editOrViewImage.setFitHeight(20.0);
            this.editOrViewImage.setFitWidth(20.0);
            this.deleteOrDeleteForeverImage.setFitHeight(21.0);
            this.deleteOrDeleteForeverImage.setFitWidth(21.0);
            if (!this.isBig) {
                AnchorPane.setRightAnchor((Node)this.deleteOrDeleteForever, (Double)37.0);
                AnchorPane.setBottomAnchor((Node)this.deleteOrDeleteForever, (Double)12.0);
                AnchorPane.setRightAnchor((Node)this.editOrView, (Double)12.0);
                AnchorPane.setBottomAnchor((Node)this.editOrView, (Double)12.0);
                AnchorPane.setRightAnchor((Node)this.archiveOrUnArchiveOrUnDelete, (Double)58.0);
                AnchorPane.setBottomAnchor((Node)this.archiveOrUnArchiveOrUnDelete, (Double)9.0);
            } else {
                this.archiveOrUnArchiveOrUnDeleteImage.setFitHeight(20.0);
                this.archiveOrUnArchiveOrUnDeleteImage.setFitHeight(20.0);
                AnchorPane.setRightAnchor((Node)this.deleteOrDeleteForever, (Double)230.0);
                AnchorPane.setBottomAnchor((Node)this.deleteOrDeleteForever, (Double)308.0);
                AnchorPane.setRightAnchor((Node)this.editOrView, (Double)195.0);
                AnchorPane.setBottomAnchor((Node)this.editOrView, (Double)308.0);
                AnchorPane.setRightAnchor((Node)this.archiveOrUnArchiveOrUnDelete, (Double)264.0);
                AnchorPane.setBottomAnchor((Node)this.archiveOrUnArchiveOrUnDelete, (Double)305.0);
            }
        }
    }

    public JalaliCalendar getGenerateDate() {
        return this.generateDate;
    }

    public void setGenerateDate(JalaliCalendar generateDate) {
        this.generateDate = generateDate;
    }

    public JalaliCalendar getModifyDate() {
        return this.modifyDate;
    }

    public void setModifyDate(JalaliCalendar modifyDate) {
        this.modifyDate = modifyDate;
    }

    public Label getNameLabel() {
        return this.nameLabel;
    }

    public void setNameLabel(Label nameLabel) {
        this.nameLabel = nameLabel;
    }

    public Label getModifyDateLabel() {
        return this.modifyDateLabel;
    }

    public void setModifyDateLabel(Label modifyDateLabel) {
        this.modifyDateLabel = modifyDateLabel;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Label getGenerateDateLabel() {
        return this.generateDateLabel;
    }

    public void setGenerateDateLabel(Label generateDateLabel) {
        this.generateDateLabel = generateDateLabel;
    }

    public JFXTextArea getTextArea() {
        return this.textArea;
    }

    public void setTextArea(JFXTextArea textArea) {
        this.textArea = textArea;
    }

    public JFXButton getEditOrView() {
        return this.editOrView;
    }

    public void setEditOrView(JFXButton editOrView) {
        this.editOrView = editOrView;
    }

    public JFXButton getArchiveOrUnArchiveOrUnDelete() {
        return this.archiveOrUnArchiveOrUnDelete;
    }

    public void setArchiveOrUnArchiveOrUnDelete(JFXButton archiveOrUnArchiveOrUnDelete) {
        this.archiveOrUnArchiveOrUnDelete = archiveOrUnArchiveOrUnDelete;
    }

    public JFXButton getDeleteOrDeleteForever() {
        return this.deleteOrDeleteForever;
    }

    public void setDeleteOrDeleteForever(JFXButton deleteOrDeleteForever) {
        this.deleteOrDeleteForever = deleteOrDeleteForever;
    }

    public ImageView getCalendar() {
        return this.calendar;
    }

    public void setCalendar(ImageView calendar) {
        this.calendar = calendar;
    }

    public ImageView getReModify() {
        return this.reModify;
    }

    public void setReModify(ImageView reModify) {
        this.reModify = reModify;
    }

    public boolean isModify() {
        return this.isModify;
    }

    public void setModify(boolean modify) {
        this.isModify = modify;
    }

    public boolean isBig() {
        return this.isBig;
    }

    public void setBig(boolean big) {
        this.isBig = big;
    }

    public ScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public FlowPane getTagsBase() {
        return this.tagsBase;
    }

    public Document getDocument() {
        return this.document;
    }

    public boolean isDeleteFromPage() {
        return this.deleteFromPage;
    }

    public void setDeleteFromPage(boolean deleteFromPage) {
        this.deleteFromPage = deleteFromPage;
    }
}

