/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.exceptions;

import io.sentry.Sentry;
import ir.deepmine.dictation.Main;
import ir.deepmine.dictation.controller.ResizeHelper;
import ir.deepmine.dictation.exceptions.AlreadyExistException;
import ir.deepmine.dictation.exceptions.ConnectionException;
import ir.deepmine.dictation.exceptions.GeneralException;
import ir.deepmine.dictation.exceptions.InvalidTokenException;
import ir.deepmine.dictation.exceptions.ServerException;
import ir.deepmine.dictation.exceptions.SuccessException;
import ir.deepmine.dictation.ui.notification.Notifications;
import ir.deepmine.dictation.ui.notification.TrayNotification;
import ir.deepmine.dictation.utils.DoActions;
import ir.deepmine.dictation.utils.GrpcExceptionsHelper;
import ir.deepmine.dictation.utils.UserInfo;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javax.sound.sampled.LineUnavailableException;

public class ExceptionHandling {
    private static ExceptionHandling instance;
    private DoActions doActions = DoActions.getInstance();

    public static ExceptionHandling getInstance() {
        if (instance == null) {
            instance = new ExceptionHandling();
        }
        return instance;
    }

    public void connectionExceptionHandling(final ConnectionException e) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TrayNotification tray = new TrayNotification("\u0642\u0637\u0639\u06cc \u0627\u0631\u062a\u0628\u0627\u0637", e.getMessage(), Notifications.WARNING);
                tray.showAndDismiss();
            }
        });
    }

    public void successExceptionHandling(final SuccessException e) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String success = "\u0639\u0645\u0644\u06cc\u0627\u062a \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u0627\u0646\u062c\u0627\u0645 \u0634\u062f";
                byte[] successBytes = success.getBytes(StandardCharsets.UTF_8);
                String successCor = new String(successBytes, StandardCharsets.UTF_8);
                TrayNotification tray = new TrayNotification(successCor, e.getMessage(), Notifications.SUCCESS);
                tray.showAndDismiss();
            }
        });
    }

    public void serverExceptionHandling(ServerException e) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TrayNotification tray = new TrayNotification("\u062e\u0637\u0627 \u062f\u0631 \u0639\u0645\u0644\u06cc\u0627\u062a", "\u0633\u0631\u0648\u0631 \u067e\u0627\u0633\u062e\u06af\u0648 \u0646\u06cc\u0633\u062a\u061b \u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.NOTICE);
                tray.showAndDismiss();
            }
        });
    }

    public void generalExceptionHandling(final GeneralException e) {
        Sentry.captureException((Throwable)e);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TrayNotification tray = new TrayNotification("\u062e\u0637\u0627 \u062f\u0631 \u0639\u0645\u0644\u06cc\u0627\u062a", e.getMessage(), Notifications.NOTICE);
                tray.showAndDismiss();
            }
        });
    }

    public void invalidTokenExceptionHandling(InvalidTokenException e) {
        try {
            this.doActions.renewAccessWithRefresh();
        }
        catch (InvalidTokenException e2) {
            Sentry.captureException((Throwable)e2);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    TrayNotification tray = new TrayNotification("\u062f\u0633\u062a\u0631\u0633\u06cc \u0646\u0627 \u0645\u0639\u062a\u0628\u0631", "\u0644\u0637\u0641\u0627 \u0628\u0631\u0646\u0627\u0645\u0647 \u0631\u0627 \u0628\u0633\u062a\u0647 \u0648 \u0645\u062c\u062f\u062f\u0627 \u0627\u062c\u0631\u0627 \u0646\u0645\u0627\u06cc\u06cc\u062f.", Notifications.NOTICE);
                    tray.showAndDismiss();
                }
            });
            e2.printStackTrace();
        }
        catch (ServerException serverException) {
            serverException.printStackTrace();
        }
        catch (ConnectionException connectionException) {
            this.connectionExceptionHandling(connectionException);
        }
        catch (GeneralException generalException) {
            this.generalExceptionHandling(generalException);
        }
        e.printStackTrace();
    }

    public void alreadyExistExceptionHandling(final AlreadyExistException e) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TrayNotification tray = new TrayNotification("\u0628\u0631\u0686\u0633\u0628 \u062a\u06a9\u0631\u0627\u0631\u06cc", e.getMessage(), Notifications.INFORMATION);
                tray.showAndDismiss();
            }
        });
    }

    public void lineUnAvailableExceptionHandling(final LineUnavailableException e) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TrayNotification tray = new TrayNotification("\u0639\u062f\u0645 \u0633\u0627\u0632\u06af\u0627\u0631\u06cc \u0645\u06cc\u06a9\u0631\u0648\u0641\u0648\u0646", e.getMessage(), Notifications.ERROR);
                tray.showAndDismiss();
            }
        });
    }

    public void grpcExceptionHandling(final GrpcExceptionsHelper helper) {
        switch (helper.getCode()) {
            case "token_not_valid": {
                try {
                    DoActions.getInstance().renewAccessWithRefresh();
                }
                catch (ConnectionException e) {
                    this.connectionExceptionHandling(e);
                }
                catch (InvalidTokenException e) {
                }
                catch (GeneralException e) {
                    this.generalExceptionHandling(e);
                }
                catch (ServerException e) {
                    this.serverExceptionHandling(e);
                }
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TrayNotification tray = new TrayNotification("\u062f\u0633\u062a\u0631\u0633\u06cc \u0646\u0627\u0645\u0639\u062a\u0628\u0631", helper.getMessage(), Notifications.INFORMATION);
                        tray.showAndDismiss();
                    }
                });
                break;
            }
            case "no_remaining_quota": 
            case "no_remaining_nonbasic_quota": {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TrayNotification tray = new TrayNotification("\u0627\u062a\u0645\u0627\u0645 \u0627\u0634\u062a\u0631\u0627\u06a9", helper.getMessage(), Notifications.INFORMATION);
                        tray.showAndDismiss();
                    }
                });
                break;
            }
            case "unknown_audio_conversion_error": {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TrayNotification tray = new TrayNotification("\u0641\u0627\u06cc\u0644 \u0646\u0627\u0645\u0639\u062a\u0628\u0631", helper.getMessage(), Notifications.INFORMATION);
                        tray.showAndDismiss();
                    }
                });
                break;
            }
            case "audio_content_error": {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TrayNotification tray = new TrayNotification("\u0645\u062d\u062a\u0648\u0627\u06cc \u0646\u0627\u0645\u0639\u062a\u0628\u0631", helper.getMessage(), Notifications.INFORMATION);
                        tray.showAndDismiss();
                    }
                });
                break;
            }
            case "token_format_not_valid": {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TrayNotification tray = new TrayNotification("\u062f\u0633\u062a\u0631\u0633\u06cc \u0646\u0627\u0645\u0639\u062a\u0628\u0631", helper.getMessage(), Notifications.INFORMATION);
                        tray.showAndDismiss();
                    }
                });
            }
        }
    }

    private void goToLogin(Stage stage) {
        System.setProperty("prism.lcdtext", "false");
        UserInfo.getInstance().logout();
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/login.fxml"));
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        Parent root = (Parent)fxmlLoader.getRoot();
        Scene scene = new Scene(root);
        stage.setScene(scene);
        stage.setResizable(true);
        ResizeHelper.addResizeListener(stage, 960.0, 564.0, Double.MAX_VALUE, Double.MAX_VALUE);
        stage.show();
    }
}

