/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.database;

import io.objectbox.annotation.Entity;
import io.objectbox.annotation.Id;
import io.objectbox.query.Query;
import ir.deepmine.dictation.database.Boxes;
import ir.deepmine.dictation.database.SpeechModel_;
import java.util.ArrayList;
import java.util.List;

@Entity
public class SpeechModel {
    @Id(assignable=true)
    private long id;
    private String language;
    private String language_fa;
    private String name;
    private String label;
    private String description;
    private int frequency;

    public SpeechModel() {
    }

    public SpeechModel(long id, String language, String language_fa, String name, String label, String description, int frequency) {
        this.id = id;
        this.language = language;
        this.language_fa = language_fa;
        this.name = name;
        this.label = label;
        this.description = description;
        this.frequency = frequency;
    }

    public static void put(SpeechModel speechModel) {
        Boxes.speechModelBox.put((Object)speechModel);
    }

    public static SpeechModel get(long id) {
        return (SpeechModel)Boxes.speechModelBox.get(id);
    }

    public static void removeAll() {
        Boxes.speechModelBox.removeAll();
    }

    public static List<SpeechModel> getAll() {
        return Boxes.speechModelBox.getAll();
    }

    public static List<SpeechModel> getAllWithModel(String model) {
        Query query = Boxes.speechModelBox.query().equal(SpeechModel_.name, model).build();
        List result = query.find();
        query.close();
        return result;
    }

    public static List<SpeechModel> getAllWithLang(String lang) {
        Query query = Boxes.speechModelBox.query().equal(SpeechModel_.language, lang).build();
        List result = query.find();
        query.close();
        return result;
    }

    public static void remove(long id) {
        Boxes.speechModelBox.remove(id);
    }

    public static void put(ArrayList<SpeechModel> speechModels) {
        Boxes.speechModelBox.put(speechModels);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage_fa() {
        return this.language_fa;
    }

    public void setLanguage_fa(String language_fa) {
        this.language_fa = language_fa;
    }
}

