/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.database;

import io.objectbox.annotation.Entity;
import io.objectbox.annotation.Index;
import io.objectbox.query.Query;
import ir.deepmine.dictation.database.Boxes;
import ir.deepmine.dictation.database.PunctuationMark_;
import ir.deepmine.dictation.database.PunctuationParent;
import ir.deepmine.dictation.utils.PunctuationsProcessing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Entity
public class PunctuationMark
extends PunctuationParent {
    @Index
    private long userId;

    public PunctuationMark() {
    }

    public PunctuationMark(long id, long userId, String word, String mark, boolean isActive) {
        this.id = id;
        this.userId = userId;
        this.word = word;
        this.mark = mark;
        this.isActive = isActive;
    }

    public static void put(PunctuationMark punctuationMark) {
        Boxes.punctuationMarkBox.put((Object)punctuationMark);
    }

    public static void put(ArrayList<PunctuationMark> punctuationMarks) {
        Boxes.punctuationMarkBox.put(punctuationMarks);
    }

    public static PunctuationMark get(long id) {
        return (PunctuationMark)Boxes.punctuationMarkBox.get(id);
    }

    public static void remove(long id) {
        Boxes.punctuationMarkBox.remove(id);
    }

    public static List<PunctuationMark> getAll(long userId) {
        Query query = Boxes.punctuationMarkBox.query().equal(PunctuationMark_.userId, userId).build();
        List punctuationMarks = query.find();
        query.close();
        return punctuationMarks;
    }

    public static void removeAll(long userId) {
        Query query = Boxes.punctuationMarkBox.query().equal(PunctuationMark_.userId, userId).build();
        List punctuationMarks = query.find();
        query.close();
        Boxes.punctuationMarkBox.remove((Collection)punctuationMarks);
    }

    public static List<PunctuationMark> getAll(long userId, boolean isActive) {
        Query query = Boxes.punctuationMarkBox.query().equal(PunctuationMark_.userId, userId).equal(PunctuationMark_.isActive, isActive).build();
        List punctuationMarks = query.find();
        query.close();
        return punctuationMarks;
    }

    public static long[] getIDs(long user_id) {
        Query query = Boxes.punctuationMarkBox.query().equal(PunctuationMark_.userId, user_id).build();
        long[] ids = query.findIds();
        query.close();
        return ids;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    @Override
    public String getMark() {
        return this.mark;
    }

    @Override
    public void setMark(String mark) {
        this.mark = mark;
    }

    @Override
    public String getWord() {
        return this.word;
    }

    @Override
    public void setWord(String word) {
        this.word = word;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean active) {
        PunctuationsProcessing punctuationsProcessing = PunctuationsProcessing.getInstance();
        if (active) {
            punctuationsProcessing.add(this.getWord(), this.getMark());
        } else {
            punctuationsProcessing.remove(this.getWord());
        }
        this.isActive = active;
    }
}

