/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.database;

import io.objectbox.annotation.Entity;
import io.objectbox.annotation.Id;
import io.objectbox.annotation.Index;
import io.objectbox.query.Query;
import ir.deepmine.dictation.database.Boxes;
import ir.deepmine.dictation.database.Plan_;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

@Entity
public class Plan {
    @Id(assignable=true)
    private long id;
    @Index
    private long user;
    @Index
    private long plan;
    @Index
    private int payed_price;
    @Index
    private boolean is_expired;
    private Date start_date;
    private Date end_date;
    private Date last_refresh_date;
    private int remaining_quota_sec;
    private boolean is_periodic;
    private int plan_quota_sec;
    private String plan_name;
    private String plan_speciality;

    public Plan() {
    }

    public Plan(long id, long user, long plan, int payed_price, Date start_date, Date end_date, Date last_refresh_date, int remaining_quota_sec, boolean is_periodic, boolean is_expired, int plan_quota_sec, String plan_name, String speciality) {
        this.id = id;
        this.user = user;
        this.plan = plan;
        this.payed_price = payed_price;
        this.start_date = start_date;
        this.end_date = end_date;
        this.last_refresh_date = last_refresh_date;
        this.remaining_quota_sec = remaining_quota_sec;
        this.is_periodic = is_periodic;
        this.is_expired = is_expired;
        this.plan_quota_sec = plan_quota_sec;
        this.plan_name = plan_name;
        this.plan_speciality = speciality;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getUser() {
        return this.user;
    }

    public void setUser(long user) {
        this.user = user;
    }

    public long getPlan() {
        return this.plan;
    }

    public void setPlan(long plan) {
        this.plan = plan;
    }

    public int getPayed_price() {
        return this.payed_price;
    }

    public void setPayed_price(int payed_price) {
        this.payed_price = payed_price;
    }

    public Date getStart_date() {
        return this.start_date;
    }

    public void setStart_date(Date start_date) {
        this.start_date = start_date;
    }

    public Date getEnd_date() {
        return this.end_date;
    }

    public void setEnd_date(Date end_date) {
        this.end_date = end_date;
    }

    public Date getLast_refresh_date() {
        return this.last_refresh_date;
    }

    public void setLast_refresh_date(Date last_refresh_date) {
        this.last_refresh_date = last_refresh_date;
    }

    public int getRemaining_quota_sec() {
        return this.remaining_quota_sec;
    }

    public void setRemaining_quota_sec(int remaining_quota_sec) {
        this.remaining_quota_sec = remaining_quota_sec;
    }

    public boolean isIs_periodic() {
        return this.is_periodic;
    }

    public void setIs_periodic(boolean is_periodic) {
        this.is_periodic = is_periodic;
    }

    public boolean isIs_expired() {
        return this.is_expired;
    }

    public void setIs_expired(boolean is_expire) {
        this.is_expired = is_expire;
    }

    public int getPlan_quota_sec() {
        return this.plan_quota_sec;
    }

    public void setPlan_quota_sec(int plan_quota_sec) {
        this.plan_quota_sec = plan_quota_sec;
    }

    public String getPlan_name() {
        return this.plan_name;
    }

    public void setPlan_name(String plan_name) {
        this.plan_name = plan_name;
    }

    public String getPlan_speciality() {
        return this.plan_speciality;
    }

    public void setPlan_speciality(String plan_speciality) {
        this.plan_speciality = plan_speciality;
    }

    public static void put(Plan plan) {
        Boxes.planBox.put((Object)plan);
    }

    public static void put(ArrayList<Plan> plans) {
        Boxes.planBox.put(plans);
    }

    public static void remove(long id) {
        Boxes.planBox.remove(id);
    }

    public static Plan get(long id) {
        return (Plan)Boxes.planBox.get(id);
    }

    public static List<Plan> getAll(long user_id) {
        Query query = Boxes.planBox.query().equal(Plan_.user, user_id).build();
        List plans = query.find();
        query.close();
        return plans;
    }

    public static List<Plan> getAll(long user_id, boolean is_expire) {
        Query query = Boxes.planBox.query().equal(Plan_.user, user_id).equal(Plan_.is_expired, is_expire).build();
        List plans = query.find();
        query.close();
        return plans;
    }

    public static List<Plan> getAll(long user_id, boolean is_expire, boolean isGolden) {
        if (isGolden) {
            Query query = Boxes.planBox.query().equal(Plan_.user, user_id).equal(Plan_.is_expired, is_expire).notEqual(Plan_.plan_speciality, "basic").build();
            List plans = query.find();
            query.close();
            return plans;
        }
        return null;
    }

    public static List<Plan> getAllPaid(long user_id) {
        Query query = Boxes.planBox.query().equal(Plan_.user, user_id).notEqual(Plan_.payed_price, 0L).build();
        List plans = query.find();
        query.close();
        return plans;
    }

    public static void removeAll(long user_id) {
        Query query = Boxes.planBox.query().equal(Plan_.user, user_id).build();
        List plans = query.find();
        query.close();
        Boxes.planBox.remove((Collection)plans);
    }
}

