/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.database;

import io.objectbox.annotation.Entity;
import io.objectbox.annotation.Id;
import io.objectbox.annotation.Index;
import io.objectbox.query.Query;
import ir.deepmine.dictation.database.Boxes;
import ir.deepmine.dictation.database.DocumentLabel_;
import java.util.Collection;
import java.util.List;

@Entity
public class DocumentLabel {
    @Id(assignable=true)
    private long id;
    private long userId;
    @Index
    private String document_uuid;
    @Index
    private long label;

    public DocumentLabel() {
    }

    public DocumentLabel(long userId, String documentId, long labelId) {
        this.document_uuid = documentId;
        this.label = labelId;
        this.userId = userId;
    }

    public static void put(DocumentLabel documentLabel) {
        Boxes.documentLabelBox.put((Object)documentLabel);
    }

    public static void put(List<DocumentLabel> documentLabels) {
        Boxes.documentLabelBox.put(documentLabels);
    }

    public static DocumentLabel get(long id) {
        return (DocumentLabel)Boxes.documentLabelBox.get(id);
    }

    public static List<DocumentLabel> getAll(long user_id) {
        Query query = Boxes.documentLabelBox.query().equal(DocumentLabel_.userId, user_id).build();
        List documentLabels = query.find();
        query.close();
        return documentLabels;
    }

    public static List<DocumentLabel> getAll(long user_id, String document_uuid) {
        Query query = Boxes.documentLabelBox.query().equal(DocumentLabel_.userId, user_id).equal(DocumentLabel_.document_uuid, document_uuid).build();
        List documentLabels = query.find();
        query.close();
        return documentLabels;
    }

    public static void removeAll(long user_id) {
        Query query = Boxes.documentLabelBox.query().equal(DocumentLabel_.userId, user_id).build();
        List documentLabels = query.find();
        query.close();
        Boxes.documentLabelBox.remove((Collection)documentLabels);
    }

    public static void remove(long id) {
        Boxes.documentLabelBox.remove(id);
    }

    public static List<DocumentLabel> getLabel(long labelId) {
        Query query = Boxes.documentLabelBox.query().equal(DocumentLabel_.label, labelId).build();
        List documentLabels = query.find();
        query.close();
        return documentLabels;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public String getDocument_uuid() {
        return this.document_uuid;
    }

    public void setDocument_uuid(String document_uuid) {
        this.document_uuid = document_uuid;
    }

    public long getLabel() {
        return this.label;
    }

    public void setLabel(long label_id) {
        this.label = label_id;
    }
}

