/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller.edit;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import ir.deepmine.dictation.exceptions.AlreadyExistException;
import ir.deepmine.dictation.exceptions.ConnectionException;
import ir.deepmine.dictation.exceptions.ExceptionHandling;
import ir.deepmine.dictation.exceptions.GeneralException;
import ir.deepmine.dictation.exceptions.InvalidFormatException;
import ir.deepmine.dictation.exceptions.InvalidTokenException;
import ir.deepmine.dictation.exceptions.ServerException;
import ir.deepmine.dictation.exceptions.TooManyRequestException;
import ir.deepmine.dictation.ui.notification.Notifications;
import ir.deepmine.dictation.ui.notification.TrayNotification;
import ir.deepmine.dictation.utils.DoActions;
import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class EditNameController {
    private DoActions doActions;
    private AnchorPane rootAnchor;
    private Label nameLabel;
    private Label familyLabel;
    private String name;
    private String family;
    private ExceptionHandling exceptionHandling;
    @FXML
    private JFXButton confirm;
    @FXML
    private JFXButton cancel;
    @FXML
    private JFXTextField nameField;
    @FXML
    private JFXTextField familyField;

    public EditNameController(AnchorPane rootAnchor, Label nameLabel, String name, String family) {
        this.rootAnchor = rootAnchor;
        this.nameLabel = nameLabel;
        this.name = name;
        this.family = family;
        this.doActions = DoActions.getInstance();
        this.exceptionHandling = ExceptionHandling.getInstance();
    }

    public void initialize() {
        this.nameField.setText(this.name);
        this.familyField.setText(this.family);
        this.confirm.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.BOLD, (double)12.0));
        this.cancel.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.BOLD, (double)12.0));
    }

    @FXML
    void cancelClick(ActionEvent event) {
        this.close();
    }

    @FXML
    void confirmClick(ActionEvent event) {
        TrayNotification tray;
        String name = "";
        String family = "";
        if (this.nameField.getText().isEmpty()) {
            tray = new TrayNotification("\u0645\u0642\u062f\u0627\u0631 \u0646\u0627\u0645 \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u062e\u0627\u0644\u06cc \u0628\u0627\u0634\u062f", "", Notifications.INFORMATION);
            tray.showAndDismiss();
        } else {
            name = this.nameField.getText();
        }
        if (this.familyField.getText().isEmpty()) {
            tray = new TrayNotification("\u0645\u0642\u062f\u0627\u0631 \u0646\u0627\u0645 \u062e\u0627\u0646\u0648\u0627\u062f\u06af\u06cc \u0646\u0645\u06cc\u200c\u062a\u0648\u0627\u0646\u062f \u062e\u0627\u0644\u06cc \u0628\u0627\u0634\u062f", "", Notifications.INFORMATION);
            tray.showAndDismiss();
        } else {
            family = this.familyField.getText();
        }
        if (!family.isEmpty() && !name.isEmpty()) {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("first_name", name);
            info.put("last_name", family);
            try {
                this.doActions.completeProfile(info);
            }
            catch (ConnectionException e) {
                this.exceptionHandling.connectionExceptionHandling(e);
            }
            catch (InvalidTokenException e) {
                this.exceptionHandling.invalidTokenExceptionHandling(e);
            }
            catch (GeneralException e) {
                this.exceptionHandling.generalExceptionHandling(e);
            }
            catch (InvalidFormatException e) {
                e.printStackTrace();
            }
            catch (TooManyRequestException e) {
                e.printStackTrace();
            }
            catch (AlreadyExistException e) {
                this.exceptionHandling.alreadyExistExceptionHandling(e);
            }
            catch (ServerException e) {
                this.exceptionHandling.serverExceptionHandling(e);
            }
            System.out.println("update profile");
            this.nameLabel.setText(name + " " + family);
            this.name = name;
            this.family = family;
            this.close();
        } else {
            System.out.println("not update");
        }
    }

    private void close() {
        this.rootAnchor.getChildren().remove(this.rootAnchor.getChildren().size() - 1);
        this.rootAnchor.getChildren().remove(this.rootAnchor.getChildren().size() - 1);
    }
}

