/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller.edit;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import ir.deepmine.dictation.exceptions.AlreadyExistException;
import ir.deepmine.dictation.exceptions.ConnectionException;
import ir.deepmine.dictation.exceptions.ExceptionHandling;
import ir.deepmine.dictation.exceptions.GeneralException;
import ir.deepmine.dictation.exceptions.InvalidFormatException;
import ir.deepmine.dictation.exceptions.InvalidTokenException;
import ir.deepmine.dictation.exceptions.ServerException;
import ir.deepmine.dictation.exceptions.TooManyRequestException;
import ir.deepmine.dictation.ui.notification.Notifications;
import ir.deepmine.dictation.ui.notification.TrayNotification;
import ir.deepmine.dictation.utils.DoActions;
import ir.deepmine.dictation.utils.Utilities;
import java.util.HashMap;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;

public class EditEmailController {
    private DoActions doActions = DoActions.getInstance();
    private ExceptionHandling exceptionHandling = ExceptionHandling.getInstance();
    private AnchorPane rootAnchor;
    private boolean isEmail;
    private Label emailLabel;
    private Label mobileLabel;
    private String name;
    private String family;
    @FXML
    private JFXButton confirm;
    @FXML
    private Label titleLabel;
    @FXML
    private JFXButton cancel;
    @FXML
    private JFXTextField field;

    public EditEmailController(AnchorPane rootAnchor, boolean isEmail, Label emailLabel, Label mobileLabel, String name, String family) {
        this.isEmail = isEmail;
        this.emailLabel = emailLabel;
        this.rootAnchor = rootAnchor;
        this.name = name;
        this.family = family;
        this.mobileLabel = mobileLabel;
    }

    public void initialize() {
        if (!this.isEmail) {
            this.field.setText(this.mobileLabel.getText());
            this.titleLabel.setText("\u0648\u06cc\u0631\u0627\u06cc\u0634 \u0634\u0645\u0627\u0631\u0647 \u0645\u0648\u0628\u0627\u06cc\u0644");
            this.field.setPromptText("\u0634\u0645\u0627\u0631\u0647 \u0645\u0648\u0628\u0627\u06cc\u0644");
        } else {
            this.field.setText(this.emailLabel.getText());
        }
    }

    @FXML
    void cancelClick(ActionEvent event) {
        this.close();
    }

    @FXML
    void confirmClick(ActionEvent event) {
        if (!this.field.getText().isEmpty()) {
            final HashMap<String, String> info = new HashMap<String, String>();
            info.put("first_name", this.name);
            info.put("last_name", this.family);
            if (this.isEmail) {
                if (Utilities.validateEmail(this.field.getText())) {
                    info.put("email", this.field.getText());
                } else {
                    this.showInvalidFormat(new InvalidFormatException("\u0641\u0631\u0645\u062a \u0627\u06cc\u0645\u06cc\u0644 \u0648\u0627\u0631\u062f \u0634\u062f\u0647 \u0635\u062d\u06cc\u062d \u0646\u0645\u06cc\u200c\u0628\u0627\u0634\u062f"));
                }
            } else if (Utilities.validatePhoneNumber(this.field.getText())) {
                info.put("mobile_number", this.field.getText());
            } else {
                this.showInvalidFormat(new InvalidFormatException("\u0641\u0631\u0645\u062a \u0634\u0645\u0627\u0631\u0647 \u0645\u0648\u0628\u0627\u06cc\u0644 \u0648\u0627\u0631\u062f \u0634\u062f\u0647 \u0635\u062d\u06cc\u062d \u0646\u0645\u06cc\u200c\u0628\u0627\u0634\u062f"));
            }
            Task task = new Task(){

                protected Object call() throws Exception {
                    try {
                        EditEmailController.this.doActions.completeProfile(info);
                    }
                    catch (ConnectionException e) {
                        EditEmailController.this.exceptionHandling.connectionExceptionHandling(e);
                    }
                    catch (InvalidTokenException e) {
                        EditEmailController.this.exceptionHandling.invalidTokenExceptionHandling(e);
                    }
                    catch (GeneralException e) {
                        EditEmailController.this.exceptionHandling.generalExceptionHandling(e);
                    }
                    catch (InvalidFormatException e) {
                        EditEmailController.this.showInvalidFormat(e);
                    }
                    catch (AlreadyExistException e) {
                        EditEmailController.this.showAlreadyExist(e);
                    }
                    catch (TooManyRequestException e) {
                        EditEmailController.this.showTooManyRequest(e);
                    }
                    catch (ServerException e) {
                        EditEmailController.this.exceptionHandling.serverExceptionHandling(e);
                    }
                    return null;
                }
            };
            Utilities.runATask((Task<Void>)task);
            if (this.isEmail) {
                this.emailLabel.setText(this.field.getText());
            } else {
                this.mobileLabel.setText(this.field.getText());
            }
            this.close();
        }
    }

    private void showInvalidFormat(final InvalidFormatException e) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TrayNotification tray = new TrayNotification("\u0641\u0631\u0645\u062a \u0627\u0634\u062a\u0628\u0627\u0647", e.getMessage(), Notifications.INFORMATION);
                tray.showAndDismiss();
            }
        });
    }

    private void showAlreadyExist(final AlreadyExistException e) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TrayNotification tray = new TrayNotification("\u0648\u062c\u0648\u062f \u0627\u06cc\u0645\u06cc\u0644", e.getMessage(), Notifications.INFORMATION);
                tray.showAndDismiss();
            }
        });
    }

    private void showTooManyRequest(final TooManyRequestException e) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TrayNotification tray = new TrayNotification("\u062f\u0631\u062e\u0648\u0627\u0633\u062a \u0632\u06cc\u0627\u062f", e.getMessage(), Notifications.INFORMATION);
                tray.showAndDismiss();
            }
        });
    }

    private void close() {
        this.rootAnchor.getChildren().remove(this.rootAnchor.getChildren().size() - 1);
        this.rootAnchor.getChildren().remove(this.rootAnchor.getChildren().size() - 1);
    }
}

