/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller;

import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Cursor;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;

public class ResizeHelper {
    public static void addResizeListener(Stage stage) {
        ResizeHelper.addResizeListener(stage, 1.0, 1.0, Double.MAX_VALUE, Double.MAX_VALUE);
    }

    public static void addResizeListener(Stage stage, double minWidth, double minHeight, double maxWidth, double maxHeight) {
        ResizeListener resizeListener = new ResizeListener(stage);
        stage.getScene().addEventHandler(MouseEvent.MOUSE_MOVED, (EventHandler)resizeListener);
        stage.getScene().addEventHandler(MouseEvent.MOUSE_PRESSED, (EventHandler)resizeListener);
        stage.getScene().addEventHandler(MouseEvent.MOUSE_DRAGGED, (EventHandler)resizeListener);
        stage.getScene().addEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)resizeListener);
        stage.getScene().addEventHandler(MouseEvent.MOUSE_EXITED_TARGET, (EventHandler)resizeListener);
        resizeListener.setMinWidth(minWidth);
        resizeListener.setMinHeight(minHeight);
        resizeListener.setMaxWidth(maxWidth);
        resizeListener.setMaxHeight(maxHeight);
    }

    static class ResizeListener
    implements EventHandler<MouseEvent> {
        private Stage stage;
        private Cursor cursorEvent = Cursor.DEFAULT;
        private boolean resizing = true;
        private int border = 4;
        private double startX = 0.0;
        private double startY = 0.0;
        private double screenOffsetX = 0.0;
        private double screenOffsetY = 0.0;
        private double startScreenX = 0.0;
        private double startScreenY = 0.0;
        private double minWidth;
        private double maxWidth;
        private double minHeight;
        private double maxHeight;

        public ResizeListener(Stage stage) {
            this.stage = stage;
        }

        public void setMinWidth(double minWidth) {
            this.minWidth = minWidth;
        }

        public void setMaxWidth(double maxWidth) {
            this.maxWidth = maxWidth;
        }

        public void setMinHeight(double minHeight) {
            this.minHeight = minHeight;
        }

        public void setMaxHeight(double maxHeight) {
            this.maxHeight = maxHeight;
        }

        public void handle(MouseEvent mouseEvent) {
            EventType mouseEventType = mouseEvent.getEventType();
            Scene scene = this.stage.getScene();
            double mouseEventX = mouseEvent.getSceneX();
            double mouseEventY = mouseEvent.getSceneY();
            double sceneWidth = scene.getWidth();
            double sceneHeight = scene.getHeight();
            if (MouseEvent.MOUSE_MOVED.equals(mouseEventType)) {
                this.cursorEvent = mouseEventX < (double)this.border && mouseEventY < (double)this.border ? Cursor.NW_RESIZE : (mouseEventX < (double)this.border && mouseEventY > sceneHeight - (double)this.border ? Cursor.SW_RESIZE : (mouseEventX > sceneWidth - (double)this.border && mouseEventY < (double)this.border ? Cursor.NE_RESIZE : (mouseEventX > sceneWidth - (double)this.border && mouseEventY > sceneHeight - (double)this.border ? Cursor.SE_RESIZE : (mouseEventX < (double)this.border ? Cursor.W_RESIZE : (mouseEventX > sceneWidth - (double)this.border ? Cursor.E_RESIZE : (mouseEventY < (double)this.border ? Cursor.N_RESIZE : (mouseEventY > sceneHeight - (double)this.border ? Cursor.S_RESIZE : Cursor.DEFAULT)))))));
                scene.setCursor(this.cursorEvent);
            } else if (MouseEvent.MOUSE_EXITED.equals(mouseEventType) || MouseEvent.MOUSE_EXITED_TARGET.equals(mouseEventType)) {
                scene.setCursor(Cursor.DEFAULT);
            } else if (MouseEvent.MOUSE_PRESSED.equals(mouseEventType)) {
                this.startX = this.stage.getWidth() - mouseEventX;
                this.startY = this.stage.getHeight() - mouseEventY;
            } else if (MouseEvent.MOUSE_DRAGGED.equals(mouseEventType) && !Cursor.DEFAULT.equals(this.cursorEvent)) {
                if (!Cursor.W_RESIZE.equals(this.cursorEvent) && !Cursor.E_RESIZE.equals(this.cursorEvent)) {
                    if (Cursor.NW_RESIZE.equals(this.cursorEvent) || Cursor.N_RESIZE.equals(this.cursorEvent) || Cursor.NE_RESIZE.equals(this.cursorEvent)) {
                        double newHeight = this.stage.getHeight() - (mouseEvent.getScreenY() - this.stage.getY());
                        if (newHeight >= this.minHeight && newHeight <= this.maxHeight) {
                            this.stage.setHeight(newHeight);
                            this.stage.setY(mouseEvent.getScreenY());
                        } else {
                            newHeight = Math.min(Math.max(newHeight, this.minHeight), this.maxHeight);
                            this.stage.setY(this.stage.getY() + this.stage.getHeight() - newHeight);
                            this.stage.setHeight(newHeight);
                        }
                    } else {
                        this.stage.setHeight(Math.min(Math.max(mouseEventY + this.startY, this.minHeight), this.maxHeight));
                    }
                }
                if (!Cursor.N_RESIZE.equals(this.cursorEvent) && !Cursor.S_RESIZE.equals(this.cursorEvent)) {
                    if (Cursor.NW_RESIZE.equals(this.cursorEvent) || Cursor.W_RESIZE.equals(this.cursorEvent) || Cursor.SW_RESIZE.equals(this.cursorEvent)) {
                        double newWidth = this.stage.getWidth() - (mouseEvent.getScreenX() - this.stage.getX());
                        if (newWidth >= this.minWidth && newWidth <= this.maxWidth) {
                            this.stage.setWidth(newWidth);
                            this.stage.setX(mouseEvent.getScreenX());
                        } else {
                            newWidth = Math.min(Math.max(newWidth, this.minWidth), this.maxWidth);
                            this.stage.setX(this.stage.getX() + this.stage.getWidth() - newWidth);
                            this.stage.setWidth(newWidth);
                        }
                    } else {
                        this.stage.setWidth(Math.min(Math.max(mouseEventX + this.startX, this.minWidth), this.maxWidth));
                    }
                }
            }
        }
    }
}

