/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller.Punctuations;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXToggleButton;
import ir.deepmine.dictation.database.DefaultPunctuationMark;
import ir.deepmine.dictation.database.PunctuationMark;
import ir.deepmine.dictation.database.PunctuationParent;
import ir.deepmine.dictation.utils.PunctuationsProcessing;
import java.util.ArrayList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;

public class PunctuationRowController {
    private static PunctuationsProcessing punctuationsProcessing = PunctuationsProcessing.getInstance();
    private PunctuationParent punctuationMark;
    private boolean isUserPunctuation;
    @FXML
    private GridPane signGrid;
    @FXML
    private Label statementLabel;
    @FXML
    private JFXButton edit;
    @FXML
    private JFXButton delete;
    @FXML
    private JFXToggleButton toggleButton;
    @FXML
    private GridPane systemPunctuationGrid;
    private ArrayList<Label> signLabels;

    public PunctuationRowController(PunctuationParent punctuationMark, boolean isUserPunctuation) {
        this.punctuationMark = punctuationMark;
        this.isUserPunctuation = isUserPunctuation;
    }

    public void initialize() {
        Label label2;
        int i;
        boolean persianOrArabic = true;
        this.signLabels = new ArrayList();
        Label qute = new Label("\"");
        Label qute2 = new Label("\"");
        qute.getStyleClass().add((Object)"grid-text");
        qute2.getStyleClass().add((Object)"grid-text");
        this.signLabels.add(qute);
        this.signGrid.add((Node)qute, 0, 0);
        this.signGrid.add((Node)qute2, this.punctuationMark.getMark().length() + 1, 0);
        if (!persianOrArabic) {
            for (i = 0; i < this.punctuationMark.getMark().length(); ++i) {
                label2 = new Label(String.valueOf(this.punctuationMark.getMark().charAt(i)));
                label2.getStyleClass().add((Object)"grid-text-sign");
                this.signLabels.add(label2);
                this.signGrid.add((Node)label2, i + 1, 0);
            }
        } else {
            for (i = 0; i < this.punctuationMark.getMark().length(); ++i) {
                label2 = new Label(String.valueOf(this.punctuationMark.getMark().charAt(i)));
                label2.getStyleClass().add((Object)"grid-text-sign");
                this.signLabels.add(label2);
                this.signGrid.add((Node)label2, this.punctuationMark.getMark().length() - i, 0);
                System.out.println(this.punctuationMark.getMark().length() - i);
            }
        }
        this.statementLabel.setText(this.punctuationMark.getWord());
        if (!this.isUserPunctuation) {
            this.edit.setVisible(false);
            this.delete.setVisible(false);
        }
        if (!this.punctuationMark.isActive()) {
            this.toggleButton.setSelected(false);
            this.statementLabel.setStyle("-fx-text-fill: #8f8f8f;");
            for (Label label2 : this.signLabels) {
                label2.setStyle("-fx-text-fill: #8f8f8f;");
            }
        }
    }

    @FXML
    void onOrOff(ActionEvent event) {
        if (this.toggleButton.isSelected()) {
            this.statementLabel.setStyle("-fx-text-fill: #fafafa;");
            for (Label label : this.signLabels) {
                label.setStyle("-fx-text-fill: #fafafa;");
            }
            this.punctuationMark.setActive(true);
        } else {
            this.statementLabel.setStyle("-fx-text-fill: #8f8f8f;");
            for (Label label : this.signLabels) {
                label.setStyle("-fx-text-fill: #8f8f8f;");
            }
            this.punctuationMark.setActive(false);
        }
        if (this.punctuationMark instanceof DefaultPunctuationMark) {
            DefaultPunctuationMark.put((DefaultPunctuationMark)this.punctuationMark);
            System.out.println("default active");
            System.out.println("active: " + ((DefaultPunctuationMark)this.punctuationMark).isActive());
        } else if (this.punctuationMark instanceof PunctuationMark) {
            PunctuationMark.put((PunctuationMark)this.punctuationMark);
            System.out.println("user active");
            System.out.println("active: " + ((PunctuationMark)this.punctuationMark).isActive());
        }
    }

    public JFXButton getEdit() {
        return this.edit;
    }

    public JFXButton getDelete() {
        return this.delete;
    }
}

