/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller;

import com.google.gson.JsonObject;
import com.jfoenix.controls.JFXComboBox;
import io.sentry.Sentry;
import ir.deepmine.dictation.Main;
import ir.deepmine.dictation.controller.ResizeHelper;
import ir.deepmine.dictation.controller.ToolbarWithSettingController;
import ir.deepmine.dictation.controller.edit.EditEmailController;
import ir.deepmine.dictation.controller.edit.EditNameController;
import ir.deepmine.dictation.controller.edit.EditPasswordController;
import ir.deepmine.dictation.database.Accent;
import ir.deepmine.dictation.database.Education;
import ir.deepmine.dictation.database.Province;
import ir.deepmine.dictation.exceptions.AlreadyExistException;
import ir.deepmine.dictation.exceptions.ConnectionException;
import ir.deepmine.dictation.exceptions.DownloadAvatarException;
import ir.deepmine.dictation.exceptions.ExceptionHandling;
import ir.deepmine.dictation.exceptions.GeneralException;
import ir.deepmine.dictation.exceptions.InvalidFormatException;
import ir.deepmine.dictation.exceptions.InvalidTokenException;
import ir.deepmine.dictation.exceptions.ServerException;
import ir.deepmine.dictation.exceptions.SuccessException;
import ir.deepmine.dictation.exceptions.TooManyRequestException;
import ir.deepmine.dictation.ui.notification.Notifications;
import ir.deepmine.dictation.ui.notification.TrayNotification;
import ir.deepmine.dictation.utils.DoActionHelper;
import ir.deepmine.dictation.utils.DoActions;
import ir.deepmine.dictation.utils.UserInfo;
import ir.deepmine.dictation.utils.Utilities;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

public class ProfileController {
    public static final String cons = "\u062b\u0628\u062a \u0646\u0634\u062f\u0647";
    HashMap<String, String> maleFemaleHashMap = new HashMap();
    HashMap<String, String> educationHashMap = new HashMap();
    HashMap<String, String> provinceHashMap = new HashMap();
    HashMap<String, String> accentHashMap = new HashMap();
    @FXML
    private AnchorPane root;
    @FXML
    private Label birthDateLabel;
    @FXML
    private Label genderLabel;
    @FXML
    private Label nameLabel;
    @FXML
    private Label telephoneLabel;
    @FXML
    private Label emailLabel;
    @FXML
    private Label accentLabel;
    @FXML
    private Label provinceLabel;
    @FXML
    private Label educationLabel;
    @FXML
    private Circle profileImgCircle;
    @FXML
    private ImageView phoneVerify;
    @FXML
    private ImageView emailVerify;
    @FXML
    private JFXComboBox<String> birthDayDateComboBox;
    @FXML
    private JFXComboBox<String> maleFemaleComboBox;
    @FXML
    private JFXComboBox<String> educationLevelComboBox;
    @FXML
    private JFXComboBox<String> provinceComboBox;
    @FXML
    private JFXComboBox<String> accentComboBox;
    private DoActions doActions = DoActions.getInstance();
    private ExceptionHandling exceptionHandling = ExceptionHandling.getInstance();
    private String name;
    private String family;
    private String initialGender;
    private String initialBirthday;
    private String initialEducation;
    private String initialProvince;
    private String initialAccent;
    private Task downloadTask;
    private int tryCount = 0;
    private double mousePressedX;
    private double mousePressedY;
    private boolean isMobile;
    private double anchorX;
    private double anchorY;

    public void initialize() {
        ObservableList birthDayYear = FXCollections.observableArrayList();
        ObservableList maleOrFemale = FXCollections.observableArrayList();
        ObservableList educationLevels = FXCollections.observableArrayList();
        ObservableList provinces = FXCollections.observableArrayList();
        ObservableList accents = FXCollections.observableArrayList();
        this.maleFemaleHashMap.put("\u062e\u0627\u0646\u0645", "female");
        this.maleFemaleHashMap.put("\u0622\u0642\u0627", "male");
        this.maleFemaleHashMap.put("female", "\u062e\u0627\u0646\u0645");
        this.maleFemaleHashMap.put("male", "\u0622\u0642\u0627");
        this.maleFemaleComboBox.setVisibleRowCount(6);
        this.accentComboBox.setVisibleRowCount(6);
        this.provinceComboBox.setVisibleRowCount(6);
        this.educationLevelComboBox.setVisibleRowCount(6);
        this.birthDayDateComboBox.setVisibleRowCount(6);
        for (int i = 1310; i <= new Date().getYear() + 1900 - 621; ++i) {
            birthDayYear.add((Object)String.valueOf(i));
        }
        maleOrFemale.add((Object)"\u062e\u0627\u0646\u0645");
        maleOrFemale.add((Object)"\u0622\u0642\u0627");
        for (Education education : Education.getAll()) {
            educationLevels.add((Object)education.getName());
            this.educationHashMap.put(education.getName(), String.valueOf(education.getId()));
        }
        for (Province province : Province.getAll()) {
            provinces.add((Object)province.getName());
            this.provinceHashMap.put(province.getName(), String.valueOf(province.getId()));
        }
        for (Accent accent : Accent.getAll()) {
            accents.add((Object)accent.getName());
            this.accentHashMap.put(accent.getName(), String.valueOf(accent.getId()));
        }
        this.birthDayDateComboBox.setItems(birthDayYear);
        this.maleFemaleComboBox.setItems(maleOrFemale);
        this.educationLevelComboBox.setItems(educationLevels);
        this.provinceComboBox.setItems(provinces);
        this.accentComboBox.setItems(accents);
        this.setLabels();
        if (ToolbarWithSettingController.isInToolBar) {
            this.root.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    ProfileController.this.anchorX = event.getSceneX();
                    ProfileController.this.anchorY = event.getSceneY();
                }
            });
            this.root.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    Stage stage = (Stage)ProfileController.this.root.getScene().getWindow();
                    stage.setX(event.getScreenX() - ProfileController.this.anchorX);
                    stage.setY(event.getScreenY() - ProfileController.this.anchorY);
                }
            });
        }
    }

    private void setLabels() {
        Image im;
        JsonObject info = null;
        try {
            info = this.doActions.getProfile();
        }
        catch (ConnectionException e) {
            this.exceptionHandling.connectionExceptionHandling(e);
        }
        catch (InvalidTokenException e) {
            this.exceptionHandling.invalidTokenExceptionHandling(e);
        }
        catch (GeneralException e) {
            this.exceptionHandling.generalExceptionHandling(e);
        }
        catch (ServerException e) {
            this.exceptionHandling.serverExceptionHandling(e);
        }
        if (info.get("first_name").isJsonNull() && !info.get("last_name").isJsonNull()) {
            this.nameLabel.setText(info.get("last_name").getAsString());
        } else if (info.get("last_name").isJsonNull() && !info.get("first_name").isJsonNull()) {
            this.nameLabel.setText(info.get("first_name").getAsString());
        } else if (!info.get("first_name").isJsonNull() && !info.get("last_name").isJsonNull()) {
            this.nameLabel.setText(info.get("first_name").getAsString() + " " + info.get("last_name").getAsString());
        } else {
            this.nameLabel.setText(cons);
        }
        this.name = info.get("first_name").getAsString();
        this.family = info.get("last_name").getAsString();
        if (info.get("mobile_number").isJsonNull()) {
            this.telephoneLabel.setText(cons);
        } else {
            this.telephoneLabel.setText(info.get("mobile_number").getAsString());
        }
        if (info.get("email").isJsonNull()) {
            this.emailLabel.setText(cons);
        } else {
            this.emailLabel.setText(info.get("email").getAsString());
        }
        if (info.get("birthday_year").isJsonNull() || info.get("birthday_year").getAsString().equals("0") || info.get("birthday_year").getAsString().replace(" ", "").equals("")) {
            this.birthDayDateComboBox.getItems().add((Object)cons);
            this.birthDayDateComboBox.setValue((Object)cons);
        } else {
            this.initialBirthday = info.get("birthday_year").getAsString();
            this.birthDayDateComboBox.setValue((Object)this.initialBirthday);
        }
        if (info.get("gender").isJsonNull() || info.get("gender").getAsString().replace(" ", "").equals("")) {
            this.maleFemaleComboBox.getItems().add((Object)cons);
            this.maleFemaleComboBox.setValue((Object)cons);
        } else {
            this.initialGender = info.get("gender").getAsString();
            this.maleFemaleComboBox.setValue((Object)this.maleFemaleHashMap.get(this.initialGender));
        }
        if (info.get("province").isJsonNull()) {
            this.provinceComboBox.getItems().add((Object)cons);
            this.provinceComboBox.setValue((Object)cons);
        } else {
            this.initialProvince = Province.get(Long.parseLong(info.get("province").getAsString())).getName();
            this.provinceComboBox.setValue((Object)this.initialProvince);
        }
        if (info.get("education_level").isJsonNull()) {
            this.educationLevelComboBox.getItems().add((Object)cons);
            this.educationLevelComboBox.setValue((Object)cons);
        } else {
            this.initialEducation = Education.get(Long.parseLong(info.get("education_level").getAsString())).getName();
            this.educationLevelComboBox.setValue((Object)this.initialEducation);
        }
        if (info.get("accent").isJsonNull()) {
            this.accentComboBox.getItems().add((Object)cons);
            this.accentComboBox.setValue((Object)cons);
        } else {
            this.initialAccent = Accent.get(Long.parseLong(info.get("accent").getAsString())).getName();
            this.accentComboBox.setValue((Object)this.initialAccent);
        }
        if (info.get("is_mobile_verified").getAsBoolean()) {
            this.isMobile = true;
            this.phoneVerify.setImage(new Image(this.getClass().getResourceAsStream("/icons/check.png")));
        }
        if (info.get("is_email_verified").getAsBoolean()) {
            this.isMobile = false;
            this.emailVerify.setImage(new Image(this.getClass().getResourceAsStream("/icons/check.png")));
        }
        if (info.get("avatar").getAsString().isEmpty()) {
            im = new Image(this.getClass().getResourceAsStream("/icons/account_circle_yellow.png"));
            this.profileImgCircle.setFill((Paint)new ImagePattern(im));
        } else {
            im = new Image(this.getClass().getResourceAsStream("/icons/account_circle_yellow.png"));
            this.profileImgCircle.setFill((Paint)new ImagePattern(im));
            String path = info.get("avatar").getAsString();
            this.setProfilePhoto(path);
        }
    }

    private void setProfilePhoto(String path) {
        this.createDownloadTask(path);
        this.runTask(this.downloadTask);
    }

    private void createDownloadTask(final String path) {
        this.downloadTask = new Task(){

            protected Object call() throws Exception {
                final Image image = DoActionHelper.getInstance().downloadAvatar(path);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ProfileController.this.profileImgCircle.setFill((Paint)new ImagePattern(image));
                    }
                });
                return null;
            }
        };
        this.downloadTask.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                System.out.println("try : " + ProfileController.this.tryCount);
                if (ProfileController.this.tryCount < UserInfo.tryMaxCount) {
                    ProfileController.this.tryCount++;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ProfileController.this.setProfilePhoto(path);
                } else {
                    Sentry.captureException((Throwable)new DownloadAvatarException());
                }
            }
        });
    }

    private void runTask(Task task) {
        Thread thread = new Thread((Runnable)task);
        thread.setDaemon(true);
        thread.start();
    }

    @FXML
    void close(ActionEvent event) {
        Task task = new Task(){

            protected Object call() {
                String birthday = null;
                String gender = null;
                String education = null;
                String province = null;
                String accent = null;
                boolean flag = false;
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("first_name", ProfileController.this.name);
                info.put("last_name", ProfileController.this.family);
                if (ProfileController.this.initialBirthday != null && !ProfileController.this.initialBirthday.equals(ProfileController.this.birthDayDateComboBox.getValue())) {
                    System.out.println("change1");
                    birthday = (String)ProfileController.this.birthDayDateComboBox.getValue();
                    info.put("birthday_year", birthday);
                    flag = true;
                }
                if (ProfileController.this.initialBirthday == null && !((String)ProfileController.this.birthDayDateComboBox.getValue()).equals(ProfileController.cons)) {
                    System.out.println("change1");
                    birthday = (String)ProfileController.this.birthDayDateComboBox.getValue();
                    info.put("birthday_year", birthday);
                    flag = true;
                }
                if (ProfileController.this.initialGender != null && !ProfileController.this.maleFemaleHashMap.get(ProfileController.this.initialGender).equals(ProfileController.this.maleFemaleComboBox.getValue())) {
                    System.out.println("change2");
                    gender = (String)ProfileController.this.maleFemaleComboBox.getValue();
                    info.put("gender", ProfileController.this.maleFemaleHashMap.get(gender));
                    flag = true;
                }
                if (ProfileController.this.initialGender == null && !((String)ProfileController.this.maleFemaleComboBox.getValue()).equals(ProfileController.cons)) {
                    System.out.println("change2");
                    gender = (String)ProfileController.this.maleFemaleComboBox.getValue();
                    info.put("gender", ProfileController.this.maleFemaleHashMap.get(gender));
                    flag = true;
                }
                if (ProfileController.this.initialEducation != null && !ProfileController.this.initialEducation.equals(ProfileController.this.educationLevelComboBox.getValue())) {
                    System.out.println("change3");
                    education = (String)ProfileController.this.educationLevelComboBox.getValue();
                    info.put("education_level_id", String.valueOf(ProfileController.this.educationHashMap.get(education)));
                    flag = true;
                }
                if (ProfileController.this.initialEducation == null && !((String)ProfileController.this.educationLevelComboBox.getValue()).equals(ProfileController.cons)) {
                    System.out.println("change3");
                    education = (String)ProfileController.this.educationLevelComboBox.getValue();
                    info.put("education_level_id", String.valueOf(ProfileController.this.educationHashMap.get(education)));
                    flag = true;
                }
                if (ProfileController.this.initialProvince != null && !ProfileController.this.initialProvince.equals(ProfileController.this.provinceComboBox.getValue())) {
                    System.out.println("change4");
                    province = (String)ProfileController.this.provinceComboBox.getValue();
                    info.put("province_id", String.valueOf(ProfileController.this.provinceHashMap.get(province)));
                    flag = true;
                }
                if (ProfileController.this.initialProvince == null && !((String)ProfileController.this.provinceComboBox.getValue()).equals(ProfileController.cons)) {
                    System.out.println("change4");
                    province = (String)ProfileController.this.provinceComboBox.getValue();
                    info.put("province_id", String.valueOf(ProfileController.this.provinceHashMap.get(province)));
                    flag = true;
                }
                if (ProfileController.this.initialAccent != null && !ProfileController.this.initialAccent.equals(ProfileController.this.accentComboBox.getValue())) {
                    System.out.println("change5");
                    accent = (String)ProfileController.this.accentComboBox.getValue();
                    info.put("accent_id", String.valueOf(ProfileController.this.accentHashMap.get(accent)));
                    flag = true;
                }
                if (ProfileController.this.initialAccent == null && !((String)ProfileController.this.accentComboBox.getValue()).equals(ProfileController.cons)) {
                    System.out.println("change5");
                    accent = (String)ProfileController.this.accentComboBox.getValue();
                    info.put("accent_id", String.valueOf(ProfileController.this.accentHashMap.get(accent)));
                    flag = true;
                }
                if (flag) {
                    System.out.println("accent id: " + ProfileController.this.accentHashMap.get(accent));
                    System.out.println(ProfileController.this.maleFemaleHashMap.get(gender) + "   " + String.valueOf(ProfileController.this.educationHashMap.get(education)) + " " + String.valueOf(ProfileController.this.provinceHashMap.get(province)) + " " + String.valueOf(ProfileController.this.accentHashMap.get(accent)));
                    try {
                        ProfileController.this.doActions.completeProfile(info);
                    }
                    catch (ConnectionException e) {
                        ProfileController.this.exceptionHandling.connectionExceptionHandling(e);
                    }
                    catch (InvalidTokenException e) {
                        ProfileController.this.exceptionHandling.invalidTokenExceptionHandling(e);
                    }
                    catch (GeneralException e) {
                        ProfileController.this.exceptionHandling.generalExceptionHandling(e);
                    }
                    catch (InvalidFormatException e) {
                        ProfileController.this.showInvalidFormat(e);
                    }
                    catch (AlreadyExistException e) {
                        ProfileController.this.showAlreadyExist(e);
                    }
                    catch (TooManyRequestException e) {
                        ProfileController.this.showTooManyRequest(e);
                    }
                    catch (ServerException e) {
                        ProfileController.this.exceptionHandling.serverExceptionHandling(e);
                    }
                }
                return null;
            }
        };
        Utilities.runATask((Task<Void>)task);
        if (!ToolbarWithSettingController.isInToolBar) {
            Thread thread = new Thread(() -> Platform.runLater(() -> {
                AnchorPane MainRoot = (AnchorPane)this.nameLabel.getScene().getRoot();
                MainRoot.getChildren().remove((Object)this.root);
                MainRoot.getChildren().remove(MainRoot.getChildren().size() - 1);
            }));
            thread.setDaemon(true);
            thread.start();
        } else {
            Stage stage = (Stage)this.root.getScene().getWindow();
            stage.close();
        }
    }

    @FXML
    void editPassword(ActionEvent event) {
        String phoneNumber = "";
        String email = "";
        if (this.isMobile) {
            phoneNumber = this.telephoneLabel.getText();
        } else {
            email = this.emailLabel.getText();
        }
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/edit-password.fxml"));
        EditPasswordController controller = new EditPasswordController(this.root, this.isMobile, phoneNumber, email);
        fxmlLoader.setController((Object)controller);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        AnchorPane anchorPane = (AnchorPane)fxmlLoader.getRoot();
        AnchorPane blackAnchor = new AnchorPane();
        blackAnchor.setPrefSize(this.root.getWidth(), this.root.getHeight());
        blackAnchor.setStyle("-fx-background-color: rgb(0,0,0,0.8)");
        this.root.getChildren().add((Object)blackAnchor);
        anchorPane.setLayoutX(this.root.getWidth() / 2.0 - 150.0);
        anchorPane.setLayoutY(this.root.getHeight() / 2.0 - 200.0);
        this.root.getChildren().add((Object)anchorPane);
    }

    @FXML
    void addAvatar(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save As");
        Stage stage = new Stage();
        stage.setResizable(false);
        stage.setAlwaysOnTop(true);
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Image Files", new String[]{"*.png", "*.jpg", "*.jpeg", "*.gif"}));
        File file = fileChooser.showOpenDialog((Window)stage);
        Image image = new Image(file.toURI().toString());
        try {
            System.out.println("do actions");
            System.out.println("name: " + this.name + " " + this.family);
            this.doActions.updateProfileAvatar(this.name, this.family, file);
        }
        catch (SuccessException e) {
            System.out.println("change avatar success");
            this.profileImgCircle.setFill((Paint)new ImagePattern(image));
        }
        catch (InvalidTokenException e) {
            this.exceptionHandling.invalidTokenExceptionHandling(e);
        }
        catch (GeneralException e) {
            this.exceptionHandling.generalExceptionHandling(e);
        }
        catch (ConnectionException e) {
            this.exceptionHandling.connectionExceptionHandling(e);
        }
        catch (ServerException e) {
            this.exceptionHandling.serverExceptionHandling(e);
        }
    }

    @FXML
    void leaveAccount(ActionEvent event) {
        System.setProperty("prism.lcdtext", "false");
        UserInfo.getInstance().logout();
        Stage stage = (Stage)this.accentLabel.getScene().getWindow();
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/login.fxml"));
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        Parent root = (Parent)fxmlLoader.getRoot();
        Scene scene = new Scene(root);
        stage.setScene(scene);
        stage.setResizable(true);
        ResizeHelper.addResizeListener(stage, 960.0, 564.0, Double.MAX_VALUE, Double.MAX_VALUE);
        stage.show();
    }

    @FXML
    void editName(MouseEvent event) {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/edit-name.fxml"));
        EditNameController editNameController = new EditNameController(this.root, this.nameLabel, this.name, this.family);
        fxmlLoader.setController((Object)editNameController);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        AnchorPane anchorPane = (AnchorPane)fxmlLoader.getRoot();
        AnchorPane blackAnchor = new AnchorPane();
        blackAnchor.setPrefSize(this.root.getWidth(), this.root.getHeight());
        blackAnchor.setStyle("-fx-background-color: rgb(0,0,0,0.8)");
        this.root.getChildren().add((Object)blackAnchor);
        anchorPane.setLayoutX(this.root.getWidth() / 2.0 - 175.0);
        anchorPane.setLayoutY(this.root.getHeight() / 2.0 - 77.0);
        this.root.getChildren().add((Object)anchorPane);
    }

    @FXML
    void editPhoneNumber(MouseEvent event) {
        if (!this.isMobile) {
            FXMLLoader fxmlLoader = new FXMLLoader();
            fxmlLoader.setLocation(Main.class.getResource("/fxml/edit-email.fxml"));
            EditEmailController controller = new EditEmailController(this.root, false, this.emailLabel, this.telephoneLabel, this.name, this.family);
            fxmlLoader.setController((Object)controller);
            try {
                fxmlLoader.load();
            }
            catch (IOException e) {
                Sentry.captureException((Throwable)e);
                e.printStackTrace();
            }
            AnchorPane anchorPane = (AnchorPane)fxmlLoader.getRoot();
            AnchorPane blackAnchor = new AnchorPane();
            blackAnchor.setPrefSize(this.root.getWidth(), this.root.getHeight());
            blackAnchor.setStyle("-fx-background-color: rgb(0,0,0,0.8)");
            this.root.getChildren().add((Object)blackAnchor);
            anchorPane.setLayoutX(this.root.getWidth() / 2.0 - 175.0);
            anchorPane.setLayoutY(this.root.getHeight() / 2.0 - 77.0);
            this.root.getChildren().add((Object)anchorPane);
        }
    }

    @FXML
    void editEmail(MouseEvent event) {
        if (this.isMobile) {
            FXMLLoader fxmlLoader = new FXMLLoader();
            fxmlLoader.setLocation(Main.class.getResource("/fxml/edit-email.fxml"));
            EditEmailController controller = new EditEmailController(this.root, true, this.emailLabel, this.telephoneLabel, this.name, this.family);
            fxmlLoader.setController((Object)controller);
            try {
                fxmlLoader.load();
            }
            catch (IOException e) {
                Sentry.captureException((Throwable)e);
                e.printStackTrace();
            }
            AnchorPane anchorPane = (AnchorPane)fxmlLoader.getRoot();
            AnchorPane blackAnchor = new AnchorPane();
            blackAnchor.setPrefSize(this.root.getWidth(), this.root.getHeight());
            blackAnchor.setStyle("-fx-background-color: rgb(0,0,0,0.8)");
            this.root.getChildren().add((Object)blackAnchor);
            anchorPane.setLayoutX(this.root.getWidth() / 2.0 - 175.0);
            anchorPane.setLayoutY(this.root.getHeight() / 2.0 - 77.0);
            this.root.getChildren().add((Object)anchorPane);
        }
    }

    private void showInvalidFormat(final InvalidFormatException e) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TrayNotification tray = new TrayNotification("\u0641\u0631\u0645\u062a \u0627\u0634\u062a\u0628\u0627\u0647", e.getMessage(), Notifications.INFORMATION);
                tray.showAndDismiss();
            }
        });
    }

    private void showAlreadyExist(final AlreadyExistException e) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TrayNotification tray = new TrayNotification("\u0648\u062c\u0648\u062f \u0627\u06cc\u0645\u06cc\u0644", e.getMessage(), Notifications.INFORMATION);
                tray.showAndDismiss();
            }
        });
    }

    private void showTooManyRequest(final TooManyRequestException e) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TrayNotification tray = new TrayNotification("\u062f\u0631\u062e\u0648\u0627\u0633\u062a \u0632\u06cc\u0627\u062f", e.getMessage(), Notifications.INFORMATION);
                tray.showAndDismiss();
            }
        });
    }
}

