/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextArea;
import com.jfoenix.controls.JFXTextField;
import io.sentry.Sentry;
import ir.deepmine.dictation.Main;
import ir.deepmine.dictation.controller.EditorPageControllers.EditorPageController;
import ir.deepmine.dictation.controller.PlanController;
import ir.deepmine.dictation.controller.PopupController;
import ir.deepmine.dictation.controller.ResizeHelper;
import ir.deepmine.dictation.controller.ToolbarWithSettingController;
import ir.deepmine.dictation.controller.enums.Page;
import ir.deepmine.dictation.controller.enums.UpdateState;
import ir.deepmine.dictation.database.Document;
import ir.deepmine.dictation.exceptions.AlreadyExistException;
import ir.deepmine.dictation.exceptions.ConnectionException;
import ir.deepmine.dictation.exceptions.ExceptionHandling;
import ir.deepmine.dictation.exceptions.GeneralException;
import ir.deepmine.dictation.exceptions.InvalidDataException;
import ir.deepmine.dictation.exceptions.InvalidTokenException;
import ir.deepmine.dictation.exceptions.NotExistException;
import ir.deepmine.dictation.exceptions.ServerException;
import ir.deepmine.dictation.exceptions.SuccessException;
import ir.deepmine.dictation.ui.ClosableTag;
import ir.deepmine.dictation.ui.CustomDocument;
import ir.deepmine.dictation.ui.SettingsForm;
import ir.deepmine.dictation.ui.TitleBar;
import ir.deepmine.dictation.ui.notification.Notifications;
import ir.deepmine.dictation.ui.notification.TrayNotification;
import ir.deepmine.dictation.utils.DoActionHelper;
import ir.deepmine.dictation.utils.DoActions;
import ir.deepmine.dictation.utils.Settings;
import ir.deepmine.dictation.utils.UserInfo;
import ir.deepmine.dictation.utils.Utilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Stage;
import javafx.util.Duration;
import javax.swing.Timer;
import org.jsoup.Jsoup;

public class MainPageController {
    private static final Image imageOnDoc = new Image(Main.class.getResourceAsStream("/icons/article_yellow.png"));
    private static final Image imageOnSpeed = new Image(Main.class.getResourceAsStream("/icons/speed_yellow.png"));
    private static final Image imageOnUser = new Image(Main.class.getResourceAsStream("/icons/person_yellow.png"));
    private static final Image imageOutDoc = new Image(Main.class.getResourceAsStream("/icons/article_gray.png"));
    private static final Image imageOutUser = new Image(Main.class.getResourceAsStream("/icons/person_gray.png"));
    private static final Image imageOutSpeed = new Image(Main.class.getResourceAsStream("/icons/speed_gray.png"));
    private static final Image syncImage = new Image(Main.class.getResourceAsStream("/icons/syncv2.png"));
    private static final Image syncGif = new Image(Main.class.getResourceAsStream("/icons/syncing.gif"));
    private static final Image imageOutUpdate = new Image(Main.class.getResourceAsStream("/icons/update_gray.png"));
    private static final Image imageOnUpdate = new Image(Main.class.getResourceAsStream("/icons/update_yellow.png"));
    private static final int LIMIT_OF_TAGS = 15;
    public static boolean isEditable;
    private static Page page;
    private final GridPane docGridPane = new GridPane();
    private final int widthOfDocWithMargin = 180;
    private final int heightOfDoc = 185;
    private final Settings setting = Settings.getInstance();
    private final DoActions doActions = DoActions.getInstance();
    private final ExceptionHandling exceptionHandling = ExceptionHandling.getInstance();
    private final DoActionHelper doActionHelper = DoActionHelper.getInstance();
    private final ToggleGroup toggleGroupSorting = new ToggleGroup();
    private final ToggleGroup toggleGroupAscendingDescending = new ToggleGroup();
    private final ArrayList<ir.deepmine.dictation.database.Label> selectedLabels = new ArrayList();
    @FXML
    private AnchorPane rootAnchor;
    @FXML
    private TextField searchField;
    @FXML
    private ToggleButton creationDateBtn;
    @FXML
    private ToggleButton editDateBtn;
    @FXML
    private ToggleButton titleBtn;
    @FXML
    private HBox docMenuItem;
    @FXML
    private ImageView docMenuImage;
    @FXML
    private HBox archivedMenuItem;
    @FXML
    private Label syncingLabel;
    private final FadeTransition fadeSyncLabel = new FadeTransition(Duration.millis((double)8000.0), (Node)this.syncingLabel);
    @FXML
    private JFXButton syncButton;
    @FXML
    private ImageView syncImageView;
    @FXML
    private ImageView titleLogo;
    @FXML
    private HBox trashedMenuItem;
    @FXML
    private Label menuDocLabel;
    @FXML
    private ScrollPane scrollPane;
    @FXML
    private ScrollBar vScrollBar;
    @FXML
    private ToggleButton upButton;
    @FXML
    private ToggleButton downButton;
    @FXML
    private JFXButton newTagButton;
    @FXML
    private JFXButton editTagButton;
    @FXML
    private JFXButton searchBtn;
    @FXML
    private HBox newTagHBox;
    @FXML
    private FlowPane closableBar;
    @FXML
    private ScrollPane tagPane;
    @FXML
    private VBox mainVBox;
    @FXML
    private Button doneNewTagButton;
    @FXML
    private JFXTextField newTagTextField;
    @FXML
    private BorderPane mainBorderPane;
    @FXML
    private Label fadeOutLabel;
    private final FadeTransition fadeOut = new FadeTransition(Duration.millis((double)8000.0), (Node)this.fadeOutLabel);
    @FXML
    private ScrollBar tagScrollBar;
    @FXML
    private AnchorPane searchAnchor;
    @FXML
    private JFXButton newDocBtn;
    @FXML
    private ImageView progressIndicator;
    @FXML
    private VBox progressIndicatorVbox;
    @FXML
    private Label emptyDoc;
    @FXML
    private Label emptyTag;
    @FXML
    private HBox updateBox;
    @FXML
    private VBox topVbox;
    @FXML
    private AnchorPane rightTopVbox;
    @FXML
    private Label versionLabel;
    @FXML
    private HBox proFileBox;
    @FXML
    private HBox subsBox;
    @FXML
    private JFXButton updateButton;
    @FXML
    private ImageView updateImage;
    private CustomDocument selected;
    private int numberOfCols = 3;
    private String selectedSide = "center";
    private String tagsState = "normal";
    private JFXButton closeSearch;
    private UserInfo userInfo = UserInfo.getInstance();
    private Page previousPage;
    private List<Document> documents = Document.getAll(this.userInfo.getUser_id(), this.setting.getStringProperty("document_sort.sort_on"), this.setting.getStringProperty("document_sort.order"), page);
    private Parent deleteAnchorPane;
    private double lastValueOfScrollListener;
    private double lastValueOfScroll;
    private IntegerProperty integerProperty;
    private int currentTime;
    private TitleBar titleBar;

    public void initialize() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MainPageController.this.progressIndicator.setVisible(true);
                MainPageController.this.progressIndicatorVbox.toFront();
            }
        });
        this.userInfo = UserInfo.getInstance();
        if (page == null || page == Page.SEARCH) {
            page = Page.NORMAL;
        }
        if (this.setting.getStringProperty("document_sort.order").equals("document_sort.order")) {
            this.setting.setProperty("document_sort.order", "descending");
        }
        if (this.setting.getStringProperty("document_sort.sort_on").equals("document_sort.sort_on")) {
            this.setting.setProperty("document_sort.sort_on", "title");
        }
        this.setting.setProperty("app_mode.mode", "main_page");
        this.versionLabel.setText("(\u06f1.\u06f0.\u06f1)");
        ToolbarWithSettingController.isInToolBar = false;
        Utilities.isInEditor = false;
        this.setTooltips();
        this.titleBar = TitleBar.getInstance("normal");
        this.titleBar.visibleLaunch(true);
        this.mainBorderPane.setTop((Node)this.titleBar);
        this.setToggleGroup();
        this.setActionForResizingScene();
        this.showAllDocsForFirstTime();
        this.addTags();
        this.bindVisiblePropertyOfLabel();
        if (this.checkUpdate()) {
            this.updateBox.setDisable(false);
        } else {
            this.recognizedWhichPage();
        }
    }

    private boolean checkUpdate() {
        UpdateState finalStatus = Main.updateStatus;
        if (finalStatus == UpdateState.SYNC) {
            this.updateButton.setDisable(true);
            return false;
        }
        if (finalStatus == UpdateState.SOFT) {
            Tooltip updateTooltip = new Tooltip();
            updateTooltip.setText("\u0646\u0633\u062e\u0647 \u062c\u062f\u06cc\u062f \u062f\u0631 \u062f\u0633\u062a\u0631\u0633 \u0627\u0633\u062a.");
            updateTooltip.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.BLACK, (double)16.0));
            updateTooltip.setShowDelay(Duration.millis((double)300.0));
            this.updateButton.setTooltip(updateTooltip);
            return true;
        }
        if (finalStatus == UpdateState.FORCE) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    MainPageController.this.disableForUpdate();
                }
            });
        }
        return true;
    }

    private void disableForUpdate() {
        this.mainVBox.setDisable(true);
        this.rightTopVbox.setDisable(true);
        this.newDocBtn.setDisable(true);
        this.docMenuItem.setStyle(null);
        this.docMenuItem.setDisable(true);
        this.proFileBox.setDisable(true);
        this.subsBox.setDisable(true);
        this.archivedMenuItem.setDisable(true);
        this.trashedMenuItem.setDisable(true);
        this.tagScrollBar.setDisable(true);
        this.docMenuImage.setDisable(true);
        this.updateBox.setStyle("-fx-background-color:#3F3F34;");
        this.updateButton.setStyle("-fx-background-color:#3F3F34;-fx-text-fill: #fff59d;");
        this.titleBar.getLaunchBtn().setDisable(true);
        this.startTimer();
        TrayNotification tray = new TrayNotification("\u0646\u0633\u062e\u0647 \u062c\u062f\u06cc\u062f", "\u0646\u0633\u062e\u0647 \u062c\u062f\u06cc\u062f \u062f\u0631 \u062f\u0633\u062a\u0631\u0633 \u0627\u0633\u062a. \u062a\u0627 \u0632\u0645\u0627\u0646\u06cc \u06a9\u0647 \u0628\u0631\u0648\u0632 \u0631\u0633\u0627\u0646\u06cc \u0627\u0646\u062c\u0627\u0645 \u0646\u0634\u0648\u062f \u0628\u0631\u0646\u0627\u0645\u0647 \u0627\u062c\u0631\u0627 \u0646\u062e\u0648\u0627\u0647\u062f \u0634\u062f.", 10000, Notifications.INFORMATION);
        tray.showAndDismiss();
    }

    private void bindEmptyDocLabel() {
        this.emptyDoc.setVisible(this.docGridPane.getChildren().size() == 0);
        switch (page) {
            case NORMAL: {
                this.emptyDoc.setText("\u0633\u0646\u062f \u062c\u062f\u06cc\u062f \u0627\u06cc\u062c\u0627\u062f \u0646\u0645\u0627\u06cc\u06cc\u062f.");
                break;
            }
            case ARCHIVE: {
                this.emptyDoc.setText("\u0633\u0646\u062f \u0628\u0627\u06cc\u06af\u0627\u0646\u06cc \u0634\u062f\u0647 \u0627\u06cc \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.");
                break;
            }
            case TRASH: {
                this.emptyDoc.setText("\u0633\u0646\u062f \u062d\u0630\u0641 \u0634\u062f\u0647 \u0627\u06cc \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.");
                break;
            }
            case SEARCH: {
                this.emptyDoc.setText("\u0646\u062a\u06cc\u062c\u0647 \u0627\u06cc \u0628\u0631\u0627\u06cc \"" + this.searchField.getText() + "\" \u06cc\u0627\u0641\u062a \u0646\u0634\u062f.");
            }
        }
    }

    private void startTimer() {
        Timer timer = new Timer(750, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (MainPageController.this.currentTime == 0) {
                            MainPageController.this.updateImage.setImage(imageOnUpdate);
                            MainPageController.this.updateButton.setStyle("-fx-background-color:#3F3F34;-fx-text-fill: #fff59d;");
                            MainPageController.this.currentTime = 1;
                        } else {
                            MainPageController.this.updateImage.setImage(imageOutUpdate);
                            MainPageController.this.updateButton.setStyle("-fx-background-color:#3F3F34;-fx-text-fill: #ababab;");
                            MainPageController.this.currentTime = 0;
                        }
                    }
                });
            }
        });
        timer.start();
    }

    private void bindEmptyTagLabel() {
        this.emptyTag.setVisible(this.closableBar.getChildren().size() == 0);
    }

    private void bindVisiblePropertyOfLabel() {
        this.bindEmptyDocLabel();
        this.bindEmptyTagLabel();
    }

    private Task createCoordinationTask() {
        this.selectedLabels.clear();
        this.syncImageView.setImage(syncGif);
        Task task = new Task(){

            protected Object call() throws Exception {
                MainPageController.this.userInfo.initializeBasic();
                return null;
            }
        };
        return task;
    }

    private void setToggleGroup() {
        this.editDateBtn.setToggleGroup(this.toggleGroupSorting);
        this.creationDateBtn.setToggleGroup(this.toggleGroupSorting);
        this.titleBtn.setToggleGroup(this.toggleGroupSorting);
        switch (this.setting.getStringProperty("document_sort.sort_on")) {
            case "creation_date": {
                this.toggleGroupSorting.selectToggle((Toggle)this.creationDateBtn);
                break;
            }
            case "update_date": {
                this.toggleGroupSorting.selectToggle((Toggle)this.editDateBtn);
                break;
            }
            case "title": {
                this.toggleGroupSorting.selectToggle((Toggle)this.titleBtn);
            }
        }
        this.downButton.setToggleGroup(this.toggleGroupAscendingDescending);
        this.upButton.setToggleGroup(this.toggleGroupAscendingDescending);
        this.toggleGroupAscendingDescending.selectToggle((Toggle)(this.setting.getStringProperty("document_sort.order").equals("ascending") ? this.downButton : this.upButton));
    }

    private void setActionForResizingScene() {
        this.scrollPane.widthProperty().addListener((obs, oldVal, newVal) -> {
            CustomDocument previousSelect = this.selected;
            if (previousSelect != null) {
                this.deselect();
                previousSelect.makeNormal();
            }
            this.numberOfCols = newVal.intValue() / 180;
            this.rearrangeGrid();
            if (previousSelect != null) {
                previousSelect.makeBig();
                this.selectCell((Pane)previousSelect);
                previousSelect.getTagsBase().setStyle("-fx-padding: 4px 4px 4px 32px;-fx-background-color:#121212;");
                previousSelect.getScrollPane().setStyle("-fx-background-color:#121212");
            }
        });
    }

    private void rearrangeGrid() {
        int i;
        ArrayList<Node> children = this.getGridChildrenAndEmpty();
        Collections.reverse(children);
        this.docGridPane.getChildren().clear();
        this.docGridPane.getColumnConstraints().clear();
        this.docGridPane.getRowConstraints().clear();
        for (i = 0; i < this.numberOfCols; ++i) {
            ColumnConstraints colConst = new ColumnConstraints();
            colConst.setPercentWidth(100.0 / (double)this.numberOfCols);
            this.docGridPane.getColumnConstraints().add((Object)colConst);
        }
        i = 0;
        while ((double)i < Math.ceil((double)this.docGridPane.getChildren().size() * 1.0 / (double)this.numberOfCols) + 1.0) {
            RowConstraints rowConst = new RowConstraints();
            rowConst.setPrefHeight(185.0);
            this.docGridPane.getRowConstraints().add((Object)rowConst);
            ++i;
        }
        this.fillGridPaneWithArrayOfNode(children);
    }

    private void setConfigOfComponents() {
        int i;
        this.progressIndicator.toFront();
        this.newDocBtn.toFront();
        this.docGridPane.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
        this.closableBar.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
        this.closableBar.setAlignment(Pos.BASELINE_LEFT);
        this.tagPane.setContent((Node)this.closableBar);
        this.scrollPane.setContent((Node)this.docGridPane);
        VBox.setVgrow((Node)this.scrollPane, (Priority)Priority.ALWAYS);
        this.editTagButton.setPadding(new Insets(0.0, 4.0, 0.0, 4.0));
        this.newTagButton.setPadding(new Insets(0.0, 6.0, 0.0, 6.0));
        this.editDateBtn.setPadding(new Insets(0.0, 4.0, 1.0, 4.0));
        this.creationDateBtn.setPadding(new Insets(0.0, 4.0, 1.0, 4.0));
        this.titleBtn.setPadding(new Insets(0.0, 4.0, 1.0, 4.0));
        this.doneNewTagButton.setPadding(new Insets(0.0, 2.0, 1.0, 2.0));
        this.fadeOut.setNode((Node)this.fadeOutLabel);
        this.fadeOut.setFromValue(1.0);
        this.fadeOut.setToValue(0.0);
        this.fadeSyncLabel.setNode((Node)this.syncingLabel);
        this.fadeSyncLabel.setFromValue(1.0);
        this.fadeSyncLabel.setToValue(0.0);
        this.newTagTextField.setOnKeyReleased(e -> {
            if (e.getCode().equals((Object)KeyCode.ENTER)) {
                this.doneNewTag();
            }
        });
        this.docGridPane.setPrefHeight(-1.0);
        this.docGridPane.setMinHeight(-1.0);
        this.docGridPane.setMaxHeight(-1.0);
        this.tagScrollBar.minProperty().bind((ObservableValue)this.tagPane.vminProperty());
        this.tagScrollBar.maxProperty().bind((ObservableValue)this.tagPane.vmaxProperty());
        this.tagScrollBar.visibleAmountProperty().bind((ObservableValue)this.tagPane.heightProperty().divide((ObservableNumberValue)this.closableBar.heightProperty()));
        this.tagScrollBar.visibleProperty().bind((ObservableValue)this.tagPane.heightProperty().lessThan((ObservableNumberValue)this.closableBar.heightProperty()));
        this.tagPane.vvalueProperty().bindBidirectional((Property)this.tagScrollBar.valueProperty());
        for (i = 0; i < this.numberOfCols; ++i) {
            ColumnConstraints colConst = new ColumnConstraints();
            colConst.setPercentWidth(100.0 / (double)this.numberOfCols);
            this.docGridPane.getColumnConstraints().add((Object)colConst);
        }
        i = 0;
        while ((double)i < Math.ceil((double)this.documents.size() * 1.0 / (double)this.numberOfCols) + 1.0) {
            RowConstraints rowConst = new RowConstraints();
            rowConst.setPrefHeight(185.0);
            this.docGridPane.getRowConstraints().add((Object)rowConst);
            ++i;
        }
        this.docGridPane.setHgap(15.0);
        this.docGridPane.setVgap(20.0);
    }

    private void setTooltips() {
        Tooltip syncTooltip = new Tooltip();
        Tooltip addTooltip = new Tooltip();
        Tooltip titleButtonTooltip = this.titleBtn.getTooltip();
        Tooltip creationDateButtonTooltip = this.creationDateBtn.getTooltip();
        Tooltip editDateButtonTooltip = this.editDateBtn.getTooltip();
        Tooltip upButtonTooltip = this.upButton.getTooltip();
        Tooltip downButtonTooltip = this.downButton.getTooltip();
        syncTooltip.setText("\u0628\u0627\u0632\u0646\u0634\u0627\u0646\u06cc \u0627\u0637\u0644\u0627\u0639\u0627\u062a");
        addTooltip.setText("\u0627\u06cc\u062c\u0627\u062f \u0633\u0646\u062f");
        syncTooltip.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.BLACK, (double)12.0));
        titleButtonTooltip.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.BLACK, (double)12.0));
        creationDateButtonTooltip.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.BLACK, (double)12.0));
        editDateButtonTooltip.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.BLACK, (double)12.0));
        addTooltip.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.BLACK, (double)12.0));
        downButtonTooltip.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.BLACK, (double)12.0));
        upButtonTooltip.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.BLACK, (double)12.0));
        syncTooltip.setShowDelay(Duration.millis((double)500.0));
        titleButtonTooltip.setShowDelay(Duration.millis((double)500.0));
        editDateButtonTooltip.setShowDelay(Duration.millis((double)500.0));
        creationDateButtonTooltip.setShowDelay(Duration.millis((double)500.0));
        addTooltip.setShowDelay(Duration.millis((double)500.0));
        upButtonTooltip.setShowDelay(Duration.millis((double)500.0));
        downButtonTooltip.setShowDelay(Duration.millis((double)500.0));
        this.syncButton.setTooltip(syncTooltip);
        this.editDateBtn.setTooltip(editDateButtonTooltip);
        this.creationDateBtn.setTooltip(creationDateButtonTooltip);
        this.editDateBtn.setTooltip(editDateButtonTooltip);
        this.newDocBtn.setTooltip(addTooltip);
        this.upButton.setTooltip(upButtonTooltip);
        this.downButton.setTooltip(downButtonTooltip);
    }

    private void showDocs() {
        switch (page) {
            case NORMAL: {
                this.showAllDocs();
                break;
            }
            case TRASH: {
                this.showDeleted();
                break;
            }
            case ARCHIVE: {
                this.showArchive();
                break;
            }
            case SEARCH: {
                this.showSearchDocs();
            }
        }
    }

    private void addTags() {
        this.closableBar.getChildren().clear();
        List<ir.deepmine.dictation.database.Label> labels = null;
        labels = ir.deepmine.dictation.database.Label.getAll(this.userInfo.getUser_id());
        for (int i = 0; i < labels.size(); ++i) {
            this.addATag(labels.get(i));
        }
    }

    private void addNewDocToMain(int row, int col, Document document) {
        CustomDocument customDocument = new CustomDocument(document);
        this.docGridPane.add((Node)customDocument, col, row, 1, 1);
        GridPane.setHalignment((Node)customDocument, (HPos)HPos.CENTER);
        GridPane.setValignment((Node)customDocument, (VPos)VPos.CENTER);
        this.setEventForClick(customDocument);
        this.setEventForDelete(customDocument);
        this.setEventForEdit(customDocument);
        this.setEventForArchive(customDocument);
    }

    private void setEventForArchive(final CustomDocument customDocument) {
        customDocument.getArchiveOrUnArchiveOrUnDelete().addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            final CustomDocument archived = (CustomDocument)((JFXButton)event.getSource()).getParent();
            Task task = new Task(){

                protected Object call() {
                    try {
                        Platform.runLater(() -> MainPageController.this.deselect());
                        if (customDocument.getDocument().getDeletion_status() == 0) {
                            MainPageController.this.doActions.documentMoveToArchive(customDocument.getDocument().getUuid());
                        } else if (customDocument.getDocument().getDeletion_status() == 1) {
                            MainPageController.this.doActions.restoreArchivedDocument(archived.getDocument().getUuid());
                        } else if (customDocument.getDocument().getDeletion_status() == 2) {
                            MainPageController.this.doActions.trashedDocumentRestore(archived.getDocument().getUuid());
                        }
                    }
                    catch (ConnectionException e) {
                        MainPageController.this.exceptionHandling.connectionExceptionHandling(e);
                    }
                    catch (NotExistException e) {
                        Sentry.captureException((Throwable)e);
                    }
                    catch (InvalidTokenException e) {
                        MainPageController.this.exceptionHandling.invalidTokenExceptionHandling(e);
                    }
                    catch (GeneralException e) {
                        MainPageController.this.exceptionHandling.generalExceptionHandling(e);
                    }
                    catch (SuccessException e) {
                        Platform.runLater(() -> {
                            MainPageController.this.exceptionHandling.successExceptionHandling(e);
                            MainPageController.this.deleteDocFromPage(archived);
                            customDocument.setDeleteFromPage(true);
                        });
                    }
                    catch (ServerException e) {
                        MainPageController.this.exceptionHandling.serverExceptionHandling(e);
                    }
                    return null;
                }
            };
            this.runATask((Task<Void>)task);
        });
    }

    private void setEventForClick(CustomDocument customDocument) {
        AtomicReference<Boolean> clickOnScroll = new AtomicReference<Boolean>(false);
        customDocument.getTextArea().addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (!((CustomDocument)((JFXTextArea)event.getSource()).getParent()).isDeleteFromPage() && customDocument.canBig()) {
                Pane source = (Pane)((JFXTextArea)event.getSource()).getParent();
                if (this.selected != null && this.selected == customDocument) {
                    this.deselect();
                    this.selected = null;
                } else if (this.selected != null) {
                    this.deselect();
                    this.selected.makeNormal();
                    this.selectCell(source);
                    this.selected = customDocument;
                } else {
                    this.selected = customDocument;
                    this.selectCell(source);
                }
                clickOnScroll.set(false);
            }
        });
        customDocument.getScrollPane().addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (!((CustomDocument)((ScrollPane)event.getSource()).getParent()).isDeleteFromPage()) {
                clickOnScroll.set(true);
                if (this.selected != null && this.selected == customDocument) {
                    this.deselect();
                    this.selected = null;
                }
            }
        });
        customDocument.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (!((CustomDocument)((Object)((Object)event.getSource()))).isDeleteFromPage() && !((Boolean)clickOnScroll.get()).booleanValue() && customDocument.canBig()) {
                Pane source = (Pane)event.getSource();
                if (this.selected != null && this.selected == customDocument) {
                    this.deselect();
                    this.selected = null;
                } else if (this.selected != null) {
                    this.deselect();
                    this.selected.makeNormal();
                    this.selectCell(source);
                    this.selected = customDocument;
                } else {
                    this.selected = customDocument;
                    this.selectCell(source);
                }
                clickOnScroll.set(false);
            }
        });
    }

    private void setEventForEdit(CustomDocument customDocument) {
        customDocument.getEditOrView().addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            CustomDocument edited = (CustomDocument)((JFXButton)event.getSource()).getParent();
            final Document document = customDocument.getDocument();
            Task task = new Task(){
                Document documentServer = null;

                protected Object call() throws Exception {
                    try {
                        this.documentServer = MainPageController.this.doActions.getDocument(document.getUuid(), false);
                        if (this.documentServer.getContent_modified_at().getTime() > document.getContent_modified_at().getTime()) {
                            System.out.println("date1: " + document.getContent_modified_at().toString() + " , date2: " + this.documentServer.getContent_modified_at().toString());
                            try {
                                String content = MainPageController.this.doActionHelper.getContentFromUrl(document.getContent_url());
                                this.documentServer.setContent(content);
                                this.documentServer.setPureContent(Jsoup.parse((String)this.documentServer.getContent()).text());
                            }
                            catch (GeneralException e) {
                                MainPageController.this.exceptionHandling.generalExceptionHandling(e);
                            }
                            catch (ConnectionException e) {
                                MainPageController.this.exceptionHandling.connectionExceptionHandling(e);
                            }
                        } else if (!document.isShowFirstTimeInEditor()) {
                            try {
                                System.out.println("first time");
                                String content = MainPageController.this.doActionHelper.getContentFromUrl(document.getContent_url());
                                this.documentServer.setContent(content);
                                this.documentServer.setPureContent(Jsoup.parse((String)this.documentServer.getContent()).text());
                            }
                            catch (GeneralException e) {
                                MainPageController.this.exceptionHandling.generalExceptionHandling(e);
                            }
                            catch (ConnectionException e) {
                                MainPageController.this.exceptionHandling.connectionExceptionHandling(e);
                            }
                        }
                        this.documentServer.setShowFirstTimeInEditor(true);
                        Document.put(this.documentServer);
                    }
                    catch (NotExistException e) {
                        Sentry.captureException((Throwable)e);
                        MainPageController.this.exceptionHandling.generalExceptionHandling(new GeneralException(e.getMessage()));
                    }
                    catch (InvalidTokenException e) {
                        MainPageController.this.exceptionHandling.invalidTokenExceptionHandling(e);
                    }
                    catch (GeneralException e) {
                        MainPageController.this.exceptionHandling.generalExceptionHandling(e);
                    }
                    catch (ConnectionException e) {
                        MainPageController.this.exceptionHandling.connectionExceptionHandling(e);
                    }
                    catch (ServerException e) {
                        MainPageController.this.exceptionHandling.serverExceptionHandling(e);
                    }
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MainPageController.this.showEditor(document.getUuid());
                        }
                    });
                    return null;
                }
            };
            this.runATask((Task<Void>)task);
        });
    }

    private void setEventForDelete(final CustomDocument customDocument) {
        customDocument.getDeleteOrDeleteForever().addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            final CustomDocument deleted = (CustomDocument)((JFXButton)event.getSource()).getParent();
            Scene mainMenuScene = this.mainBorderPane.getScene();
            AnchorPane mainMenu = (AnchorPane)mainMenuScene.getRoot();
            PopupController controller = this.addDeleteScene(customDocument, mainMenu);
            controller.getCancelBtn().addEventHandler(MouseEvent.MOUSE_CLICKED, event1 -> this.closeDeleteScene((AnchorPane)this.deleteAnchorPane));
            controller.getSubmitBtn().addEventHandler(MouseEvent.MOUSE_CLICKED, event1 -> {
                Task task = new Task(){

                    protected Object call() {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    MainPageController.this.deselect();
                                    if (customDocument.getDocument().getDeletion_status() == 2) {
                                        MainPageController.this.doActions.deleteTrashedDocument(deleted.getDocument().getUuid());
                                    } else if (customDocument.getDocument().getDeletion_status() == 1) {
                                        MainPageController.this.doActions.deleteDocumentMoveToTrash(deleted.getDocument().getUuid());
                                    } else if (customDocument.getDocument().getDeletion_status() == 0) {
                                        MainPageController.this.doActions.deleteDocumentMoveToTrash(deleted.getDocument().getUuid());
                                    }
                                }
                                catch (NotExistException e) {
                                    Sentry.captureException((Throwable)e);
                                    e.printStackTrace();
                                }
                                catch (InvalidTokenException e) {
                                    MainPageController.this.exceptionHandling.invalidTokenExceptionHandling(e);
                                }
                                catch (GeneralException e) {
                                    TrayNotification tray = new TrayNotification("\u062e\u0637\u0627 \u062f\u0631 \u0639\u0645\u0644\u06cc\u0627\u062a", e.getMessage(), Notifications.NOTICE);
                                    tray.showAndDismiss();
                                }
                                catch (SuccessException e) {
                                    Platform.runLater((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            MainPageController.this.exceptionHandling.successExceptionHandling(e);
                                            MainPageController.this.deleteDocFromPage(deleted);
                                            customDocument.setDeleteFromPage(true);
                                            MainPageController.this.closeDeleteScene((AnchorPane)MainPageController.this.deleteAnchorPane);
                                        }
                                    });
                                }
                                catch (ConnectionException e) {
                                    MainPageController.this.exceptionHandling.connectionExceptionHandling(e);
                                }
                                catch (ServerException e) {
                                    MainPageController.this.exceptionHandling.serverExceptionHandling(e);
                                }
                            }
                        });
                        return null;
                    }
                };
                this.runATask((Task<Void>)task);
            });
        });
    }

    private void deleteDocFromPage(CustomDocument deleted) {
        this.docGridPane.getChildren().remove((Object)deleted);
        ArrayList<Node> children = new ArrayList<Node>();
        children.addAll((Collection<Node>)this.docGridPane.getChildren());
        this.fillGridPaneWithArrayOfNode(children);
    }

    private ArrayList<Node> getGridChildrenAndEmpty() {
        ArrayList<Node> children = new ArrayList<Node>((Collection<Node>)this.docGridPane.getChildren());
        this.docGridPane.getChildren().clear();
        return children;
    }

    private void fillGridPaneWithExtraArrayOfNode(ArrayList<Node> children, int indexNull) {
        this.docGridPane.getChildren().remove(indexNull, this.docGridPane.getChildren().size());
        for (int i = 0; i < children.size(); ++i) {
            int row = (int)Math.floor((double)(i + indexNull) / ((double)this.numberOfCols * 1.0));
            int col = (i + indexNull) % this.numberOfCols;
            this.docGridPane.add(children.get(i), col, row, 1, 1);
        }
    }

    private void fillGridPaneWithArrayOfNode(ArrayList<Node> children) {
        this.docGridPane.getChildren().clear();
        for (int i = 0; i < children.size(); ++i) {
            int row = (int)Math.floor((double)i / ((double)this.numberOfCols * 1.0));
            int col = i % this.numberOfCols;
            this.docGridPane.add(children.get(i), col, row, 1, 1);
        }
        this.bindEmptyDocLabel();
    }

    void showAllDocsForFirstTime() {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                MainPageController.this.documents = Document.getAll(MainPageController.this.userInfo.getUser_id(), MainPageController.this.setting.getStringProperty("document_sort.sort_on"), MainPageController.this.setting.getStringProperty("document_sort.order"), page);
                MainPageController.this.setConfigOfComponents();
                MainPageController.this.fillGridPaneWithArrayOfDocument(MainPageController.this.documents);
                MainPageController.this.scrollPane.setContent((Node)MainPageController.this.docGridPane);
                return null;
            }
        };
        this.runATask(task);
    }

    void showSearchDocs() {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                MainPageController.this.documents = Document.getAll(MainPageController.this.userInfo.getUser_id(), MainPageController.this.setting.getStringProperty("document_sort.sort_on"), MainPageController.this.setting.getStringProperty("document_sort.order"), MainPageController.this.previousPage);
                MainPageController.this.fillGridPaneWithArrayOfDocument(MainPageController.this.documents);
                return null;
            }
        };
        this.runATask(task);
    }

    private void fillGridPaneWithArrayOfDocument(final List<Document> documents) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MainPageController.this.docGridPane.getChildren().clear();
                for (int i = 0; i < documents.size(); ++i) {
                    int row = (int)Math.floor((double)i / ((double)MainPageController.this.numberOfCols * 1.0));
                    int col = i % MainPageController.this.numberOfCols;
                    MainPageController.this.addNewDocToMain(row, col, (Document)documents.get(i));
                }
                MainPageController.this.bindEmptyDocLabel();
            }
        });
    }

    private void showEditor(String documentUuId) {
        isEditable = false;
        if (documentUuId == null) {
            isEditable = true;
        } else if (Document.get(documentUuId).getDeletion_status() == 0) {
            isEditable = true;
        }
        System.setProperty("prism.lcdtext", "false");
        Stage stage = (Stage)this.mainBorderPane.getScene().getWindow();
        stage.getIcons().add((Object)Utilities.icon);
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/Editor/EditorPage.fxml"));
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        Parent root = (Parent)fxmlLoader.getRoot();
        Scene scene = stage.getHeight() <= 642.5 || stage.getWidth() <= 1100.0 ? new Scene(root) : new Scene(root, stage.getWidth(), stage.getHeight());
        stage.setScene(scene);
        stage.setResizable(true);
        ResizeHelper.addResizeListener(stage, stage.getScene().getWidth(), stage.getScene().getHeight(), Double.MAX_VALUE, Double.MAX_VALUE);
        stage.sizeToScene();
        stage.show();
        ((EditorPageController)fxmlLoader.getController()).load(documentUuId, isEditable);
    }

    private PopupController addDeleteScene(CustomDocument customDocument, AnchorPane mainMenu) {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/popup.fxml"));
        PopupController controller = new PopupController("\u0633\u0646\u062f: ", customDocument.getName());
        fxmlLoader.setController((Object)controller);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        this.deleteAnchorPane = (Parent)fxmlLoader.getRoot();
        AnchorPane blackAnchor = new AnchorPane();
        blackAnchor.setPrefSize(this.rootAnchor.getWidth(), this.rootAnchor.getHeight());
        blackAnchor.setStyle("-fx-background-color: rgb(0,0,0,0.8)");
        mainMenu.getChildren().add((Object)blackAnchor);
        this.deleteAnchorPane.setLayoutX(this.rootAnchor.getWidth() / 2.0 - 140.0);
        this.deleteAnchorPane.setLayoutY(this.rootAnchor.getHeight() / 2.0 - 77.0);
        mainMenu.getChildren().add((Object)this.deleteAnchorPane);
        return controller;
    }

    private void closeDeleteScene(AnchorPane anchorPane) {
        AnchorPane MainRoot = (AnchorPane)this.rootAnchor.getScene().getRoot();
        MainRoot.getChildren().remove((Object)anchorPane);
        MainRoot.getChildren().remove(MainRoot.getChildren().size() - 1);
    }

    private void selectCell(Pane doc) {
        this.lastValueOfScroll = this.lastValueOfScrollListener;
        int clickedRow = GridPane.getRowIndex((Node)doc);
        int clickedCol = GridPane.getColumnIndex((Node)doc);
        Stack<Node> children = new Stack<Node>();
        children.addAll((Collection<Node>)this.docGridPane.getChildren());
        Collections.reverse(children);
        int numberOfRows = (int)Math.ceil((double)this.docGridPane.getChildren().size() / ((double)this.numberOfCols * 1.0));
        this.docGridPane.getChildren().clear();
        if (numberOfRows == 1 && clickedCol != this.numberOfCols - 1) {
            this.zoomCenterCells(clickedRow, clickedCol, children);
        } else if (numberOfRows == 1 && clickedCol == this.numberOfCols - 1) {
            this.zoomSideCells(clickedRow, clickedCol, children);
        } else if (clickedRow == numberOfRows - 1 && clickedCol == this.numberOfCols - 1) {
            this.zoomLastCells(clickedRow, clickedCol, children);
        } else if (clickedRow == numberOfRows - 1) {
            this.zoomBottomCells(clickedRow, clickedCol, children);
        } else if (clickedCol != this.numberOfCols - 1) {
            this.zoomCenterCells(clickedRow, clickedCol, children);
        } else {
            this.zoomSideCells(clickedRow, clickedCol, children);
        }
    }

    private void zoomSideCells(int clickedRow, int clickedCol, Stack<Node> children) {
        int i = 0;
        this.selectedSide = "side";
        while (children.size() > 0) {
            int row = (int)Math.floor((double)i / ((double)this.numberOfCols * 1.0));
            int col = i % this.numberOfCols;
            ++i;
            if (row == clickedRow && col == clickedCol - 1) {
                Node before = children.pop();
                this.docGridPane.add(children.pop(), col, row, 2, 2);
                children.push(before);
                continue;
            }
            if (row == clickedRow + 1 && col == clickedCol - 1 || row == clickedRow + 1 && col == clickedCol || row == clickedRow && col == clickedCol) continue;
            this.docGridPane.add(children.pop(), col, row, 1, 1);
        }
    }

    private void zoomCenterCells(int clickedRow, int clickedCol, Stack<Node> children) {
        int i = 0;
        while (children.size() > 0) {
            int row = (int)Math.floor((double)i / ((double)this.numberOfCols * 1.0));
            int col = i % this.numberOfCols;
            ++i;
            if (row == clickedRow && col == clickedCol) {
                this.docGridPane.add(children.pop(), col, row, 2, 2);
                continue;
            }
            if (row == clickedRow + 1 && col == clickedCol + 1 || row == clickedRow + 1 && col == clickedCol || row == clickedRow && col == clickedCol + 1) continue;
            this.docGridPane.add(children.pop(), col, row, 1, 1);
        }
    }

    private void zoomBottomCells(int clickedRow, int clickedCol, Stack<Node> children) {
        int i = 0;
        this.selectedSide = "bottom";
        while (children.size() > 0) {
            int row = (int)Math.floor((double)i / ((double)this.numberOfCols * 1.0));
            int col = i % this.numberOfCols;
            ++i;
            if (row == clickedRow - 1 && col == clickedCol) {
                Stack<Node> skipped = new Stack<Node>();
                for (int j = 0; j < this.numberOfCols; ++j) {
                    skipped.push(children.pop());
                }
                CustomDocument customDocument = (CustomDocument)children.pop();
                this.docGridPane.add((Node)customDocument, col, row, 2, 2);
                for (int j = 0; j < this.numberOfCols; ++j) {
                    children.push((Node)skipped.pop());
                }
                continue;
            }
            if (row == clickedRow - 1 && col == clickedCol + 1 || row == clickedRow && col == clickedCol || row == clickedRow && col == clickedCol + 1) continue;
            this.docGridPane.add(children.pop(), col, row, 1, 1);
        }
    }

    private void zoomLastCells(int clickedRow, int clickedCol, Stack<Node> children) {
        int i = 0;
        this.selectedSide = "last";
        while (children.size() > 0) {
            int row = (int)Math.floor((double)i / ((double)this.numberOfCols * 1.0));
            int col = i % this.numberOfCols;
            ++i;
            if (row == clickedRow - 1 && col == clickedCol - 1) {
                Stack<Node> skipped = new Stack<Node>();
                for (int j = 0; j < this.numberOfCols + 1; ++j) {
                    skipped.push(children.pop());
                }
                CustomDocument customDocument = (CustomDocument)children.pop();
                this.docGridPane.add((Node)customDocument, col, row, 2, 2);
                for (int j = 0; j < this.numberOfCols + 1; ++j) {
                    children.push((Node)skipped.pop());
                }
                continue;
            }
            if (row == clickedRow - 1 && col == clickedCol || row == clickedRow && col == clickedCol || row == clickedRow && col == clickedCol - 1) continue;
            this.docGridPane.add(children.pop(), col, row, 1, 1);
        }
    }

    private void deselect() {
        ArrayList<Node> children = new ArrayList<Node>();
        children.addAll((Collection<Node>)this.docGridPane.getChildren());
        Collections.reverse(children);
        switch (this.selectedSide) {
            case "side": {
                int i = children.indexOf((Object)this.selected);
                Node ith = children.get(i);
                Node i1th = children.get(i - 1);
                children.remove(i1th);
                children.remove(ith);
                children.add(i - 1, ith);
                children.add(i, i1th);
                this.selectedSide = "center";
                break;
            }
            case "bottom": {
                int i = children.indexOf((Object)this.selected);
                Node ith = children.get(i);
                children.remove(ith);
                children.add(i - this.numberOfCols, ith);
                this.selectedSide = "center";
                break;
            }
            case "last": {
                int i = children.indexOf((Object)this.selected);
                Node ith = children.get(i);
                children.remove(ith);
                children.add(i - this.numberOfCols - 1, ith);
                this.selectedSide = "center";
                break;
            }
        }
        Collections.reverse(children);
        this.fillGridPaneWithArrayOfNode(children);
    }

    public void addATag(final ir.deepmine.dictation.database.Label label) {
        final ClosableTag tag = new ClosableTag(label, true);
        this.closableBar.getChildren().add((Object)tag);
        this.bindEmptyTagLabel();
        tag.getCloseBtn().addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            Task task = new Task(){

                protected Object call() throws Exception {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MainPageController.this.closableBar.getChildren().remove((Object)tag);
                            MainPageController.this.bindEmptyTagLabel();
                            System.out.println("run task remove label");
                            try {
                                MainPageController.this.doActions.removeLabel(label.getId());
                            }
                            catch (ConnectionException e) {
                                MainPageController.this.exceptionHandling.connectionExceptionHandling(e);
                            }
                            catch (NotExistException e) {
                                Sentry.captureException((Throwable)e);
                                e.printStackTrace();
                            }
                            catch (InvalidTokenException e) {
                                MainPageController.this.exceptionHandling.invalidTokenExceptionHandling(e);
                            }
                            catch (GeneralException e) {
                                MainPageController.this.exceptionHandling.generalExceptionHandling(e);
                            }
                            catch (SuccessException e) {
                                MainPageController.this.exceptionHandling.successExceptionHandling(e);
                            }
                            catch (ServerException e) {
                                MainPageController.this.exceptionHandling.serverExceptionHandling(e);
                            }
                        }
                    });
                    return null;
                }
            };
            this.runATask((Task<Void>)task);
        });
        tag.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (!tag.getMode().equals("edit")) {
                if (this.selectedLabels.contains(tag.getLabel())) {
                    this.selectedLabels.remove(tag.getLabel());
                } else {
                    this.selectedLabels.add(tag.getLabel());
                }
                if (this.selectedLabels.size() == 0) {
                    this.showDocs();
                } else if (this.searchField.getText().isEmpty()) {
                    this.fillGridPaneWithArrayOfDocument(Document.getAll(page, this.selectedLabels, this.setting.getStringProperty("document_sort.sort_on"), this.setting.getStringProperty("document_sort.sort_on")));
                } else {
                    this.fillGridPaneWithArrayOfDocument(Document.getAll(page, this.selectedLabels, this.setting.getStringProperty("document_sort.sort_on"), this.setting.getStringProperty("document_sort.order"), this.searchField.getText()));
                }
            }
        });
    }

    public void makeANewTag(String text) {
        if (this.closableBar.getChildren().size() < 15) {
            ir.deepmine.dictation.database.Label label = null;
            try {
                label = this.doActions.createLabel(text);
                label.setUserId(this.userInfo.getUser_id());
                this.addATag(label);
            }
            catch (AlreadyExistException e) {
                this.exceptionHandling.alreadyExistExceptionHandling(e);
            }
            catch (ConnectionException e) {
                this.exceptionHandling.connectionExceptionHandling(e);
            }
            catch (InvalidTokenException e) {
                this.exceptionHandling.invalidTokenExceptionHandling(e);
            }
            catch (GeneralException e) {
                this.exceptionHandling.generalExceptionHandling(e);
            }
            catch (InvalidDataException e) {
                if (text.length() > 32) {
                    TrayNotification tray = new TrayNotification("\u0645\u062d\u062f\u0648\u062f\u06cc\u062a \u0627\u0646\u062f\u0627\u0632\u0647", "\u0627\u0646\u062f\u0627\u0632\u0647 \u0627\u06cc\u0646 \u0628\u0631\u0686\u0633\u0628 \u0628\u06cc\u0634\u062a\u0631 \u0627\u0632 \u062d\u062f \u0645\u062c\u0627\u0632 \u0627\u0633\u062a.", Notifications.NOTICE);
                    tray.showAndDismiss();
                }
            }
            catch (ServerException e) {
                this.exceptionHandling.serverExceptionHandling(e);
            }
        } else {
            TrayNotification tray = new TrayNotification("\u0645\u062d\u062f\u0648\u062f\u06cc\u062a \u062a\u0639\u062f\u0627\u062f \u0628\u0631\u0686\u0633\u0628", "\u0628\u0631\u0686\u0633\u0628 \u0647\u0627\u06cc \u0634\u0645\u0627 \u0628\u06cc\u0634 \u0627\u0632 \u062c\u062f \u0645\u062c\u0627\u0632 \u0627\u0633\u062a.", Notifications.NOTICE);
            tray.showAndDismiss();
        }
    }

    private void runATask(Task<Void> task) {
        task.setOnSucceeded(event -> {
            System.out.println("success");
            this.progressIndicator.setVisible(false);
            this.progressIndicatorVbox.toBack();
        });
        task.setOnCancelled(event -> {
            System.out.println("cancel");
            this.progressIndicator.setVisible(false);
            this.progressIndicatorVbox.toBack();
        });
        task.setOnFailed(event -> {
            task.getException().printStackTrace();
            Sentry.captureException((Throwable)task.getException());
            System.out.println("failed");
            this.progressIndicator.setVisible(false);
            this.progressIndicatorVbox.toBack();
        });
        this.progressIndicator.setVisible(true);
        this.progressIndicatorVbox.toFront();
        Thread th = new Thread((Runnable)task);
        th.setDaemon(true);
        th.start();
    }

    @FXML
    void changeOnImageDoc(MouseEvent event) {
        ((ImageView)((HBox)event.getSource()).getChildren().get(1)).setImage(imageOnDoc);
    }

    @FXML
    void changeOnImageSpeed(MouseEvent event) {
        ((ImageView)((HBox)event.getSource()).getChildren().get(1)).setImage(imageOnSpeed);
    }

    @FXML
    void changeOnImageUpdate(MouseEvent event) {
        this.updateImage.setImage(imageOnUpdate);
    }

    @FXML
    void changeOutImageUpdate(MouseEvent event) {
        this.updateImage.setImage(imageOutUpdate);
    }

    @FXML
    void changeOnImageUser(MouseEvent event) {
        ((ImageView)((HBox)event.getSource()).getChildren().get(1)).setImage(imageOnUser);
    }

    @FXML
    void changeOutImageDoc(MouseEvent event) {
        if (page != Page.NORMAL) {
            ((ImageView)((HBox)event.getSource()).getChildren().get(1)).setImage(imageOutDoc);
        }
    }

    @FXML
    void changeOutImageUser(MouseEvent event) {
        ((ImageView)((HBox)event.getSource()).getChildren().get(1)).setImage(imageOutUser);
    }

    @FXML
    void changeOutImageSpeed(MouseEvent event) {
        ((ImageView)((HBox)event.getSource()).getChildren().get(1)).setImage(imageOutSpeed);
    }

    @FXML
    void makeANewDoc() {
        this.showEditor(null);
    }

    @FXML
    void editTags() {
        if (this.tagsState.equals("normal")) {
            this.tagsState = "edit";
            this.editTagButton.setText("\u062a\u0627\u06cc\u06cc\u062f");
            this.editTagButton.setPrefWidth(38.0);
            this.newTagButton.setDisable(true);
            this.upButton.setDisable(true);
            this.downButton.setDisable(true);
            this.editDateBtn.setDisable(true);
            this.creationDateBtn.setDisable(true);
            this.titleBtn.setDisable(true);
            this.searchField.setDisable(true);
            this.searchField.setVisible(false);
            this.searchBtn.setVisible(false);
            for (Node child : this.closableBar.getChildren()) {
                ((ClosableTag)child).editMode();
            }
            this.fadeOutLabel.setVisible(true);
            this.fadeOut.playFromStart();
        } else {
            this.tagsState = "normal";
            this.editTagButton.setText("\u0648\u06cc\u0631\u0627\u06cc\u0634 \u062a\u06af \u0647\u0627");
            this.editTagButton.setPrefWidth(83.0);
            this.enableAllTagsFeatures();
            this.showDocs();
            for (Node child : this.closableBar.getChildren()) {
                if (((ClosableTag)child).isEdited()) {
                    System.out.println("edit and server");
                    try {
                        this.doActions.updateLabel(((ClosableTag)child).getLabel().getId(), ((ClosableTag)child).getTf().getText());
                    }
                    catch (InvalidTokenException e) {
                        this.exceptionHandling.invalidTokenExceptionHandling(e);
                    }
                    catch (NotExistException e) {
                        Sentry.captureException((Throwable)e);
                    }
                    catch (GeneralException e) {
                        this.exceptionHandling.generalExceptionHandling(e);
                    }
                    catch (ConnectionException e) {
                        this.exceptionHandling.connectionExceptionHandling(e);
                    }
                    catch (ServerException e) {
                        this.exceptionHandling.serverExceptionHandling(e);
                    }
                    ((ClosableTag)child).setEdited(false);
                }
                ((ClosableTag)child).normalMode();
            }
        }
    }

    @FXML
    void newTag() {
        this.newTagHBox.toFront();
        this.newTagButton.setDisable(true);
        this.newTagHBox.setVisible(true);
        this.newTagHBox.setDisable(false);
        this.newTagButton.setVisible(false);
        this.newTagButton.setDisable(true);
        this.editTagButton.setDisable(true);
        this.upButton.setDisable(true);
        this.downButton.setDisable(true);
        this.editDateBtn.setDisable(true);
        this.creationDateBtn.setDisable(true);
        this.titleBtn.setDisable(true);
        this.searchField.setDisable(true);
        this.searchField.setVisible(false);
        this.searchBtn.setVisible(false);
    }

    @FXML
    void search() {
        if (this.searchField.getText().equals("")) {
            return;
        }
        if (this.searchAnchor.getChildren().size() == 2) {
            this.setCloseBtnForSearch();
        }
        if (this.searchField.getText().equals("") && this.searchAnchor.getChildren().contains((Object)this.closeSearch)) {
            this.searchAnchor.getChildren().remove((Object)this.closeSearch);
            this.searchField.setPadding(new Insets(3.0, 8.0, 3.0, 24.0));
            page = this.previousPage;
        } else {
            if (page != Page.SEARCH) {
                this.previousPage = page;
            }
            page = Page.SEARCH;
        }
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                if (MainPageController.this.selectedLabels.size() == 0) {
                    MainPageController.this.documents = Document.search(MainPageController.this.userInfo.getUser_id(), MainPageController.this.searchField.getText(), MainPageController.this.setting.getStringProperty("document_sort.sort_on"), MainPageController.this.setting.getStringProperty("document_sort.order"), MainPageController.this.previousPage);
                    MainPageController.this.fillGridPaneWithArrayOfDocument(MainPageController.this.documents);
                } else {
                    MainPageController.this.documents = Document.getAll(MainPageController.this.previousPage, MainPageController.this.selectedLabels, MainPageController.this.setting.getStringProperty("document_sort.sort_on"), MainPageController.this.setting.getStringProperty("document_sort.order"), MainPageController.this.searchField.getText());
                    MainPageController.this.fillGridPaneWithArrayOfDocument(MainPageController.this.documents);
                }
                return null;
            }
        };
        this.runATask(task);
        this.searchBtn.setStyle("-fx-background-color: rgba(0,0,0,0);");
    }

    private void setCloseBtnForSearch() {
        this.closeSearch = new JFXButton();
        ImageView imageView = new ImageView(new Image(this.getClass().getResourceAsStream("/icons/close_red.png")));
        imageView.setFitWidth(12.0);
        imageView.setFitHeight(12.0);
        this.closeSearch.setGraphic((Node)imageView);
        this.closeSearch.setLayoutX(190.0);
        this.closeSearch.setLayoutY(2.0);
        this.closeSearch.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.closeSearch.setPrefSize(22.0, 22.0);
        this.closeSearch.setMaxSize(22.0, 22.0);
        this.closeSearch.toFront();
        this.searchAnchor.getChildren().add((Object)this.closeSearch);
        this.searchField.setPadding(new Insets(3.0, 22.0, 3.0, 24.0));
        this.closeSearch.setOnAction((EventHandler)new EventHandler<javafx.event.ActionEvent>(){

            public void handle(javafx.event.ActionEvent event) {
                MainPageController.this.searchField.setText("");
                page = MainPageController.this.previousPage;
                MainPageController.this.showDocs();
                MainPageController.this.searchField.setPadding(new Insets(3.0, 8.0, 3.0, 24.0));
                MainPageController.this.searchAnchor.getChildren().remove((Object)MainPageController.this.closeSearch);
            }
        });
    }

    private void recognizedWhichPage() {
        if (page == Page.NORMAL) {
            this.archivedMenuItem.setStyle(null);
            this.trashedMenuItem.setStyle(null);
            this.docMenuItem.setStyle("-fx-background-color:#3F3F34;");
            this.docMenuImage.setImage(imageOnDoc);
            this.menuDocLabel.setStyle("-fx-text-fill: #fff59d;");
        } else if (page == Page.ARCHIVE) {
            this.archivedMenuItem.setStyle("-fx-background-color:#3F3F34;");
            this.trashedMenuItem.setStyle(null);
            this.docMenuItem.setStyle(null);
            this.docMenuImage.setImage(imageOutDoc);
            this.menuDocLabel.setStyle(null);
        } else if (page == Page.TRASH) {
            this.archivedMenuItem.setStyle(null);
            this.trashedMenuItem.setStyle("-fx-background-color:#3F3F34;");
            this.docMenuItem.setStyle(null);
            this.docMenuImage.setImage(imageOutDoc);
            this.menuDocLabel.setStyle(null);
        }
    }

    private void enableAllTagsFeatures() {
        this.newTagButton.setVisible(true);
        this.editTagButton.setDisable(false);
        this.newTagHBox.setVisible(false);
        this.newTagHBox.setDisable(true);
        this.newTagButton.setDisable(false);
        this.upButton.setDisable(false);
        this.downButton.setDisable(false);
        this.editDateBtn.setDisable(false);
        this.creationDateBtn.setDisable(false);
        this.titleBtn.setDisable(false);
        this.searchField.setDisable(false);
        this.searchField.setVisible(true);
        this.searchBtn.setVisible(true);
    }

    @FXML
    void doneNewTag() {
        this.enableAllTagsFeatures();
        this.newTagHBox.toFront();
        this.makeANewTag(this.newTagTextField.getText());
        this.newTagTextField.setText("");
    }

    @FXML
    void settingsButtonPressed() {
        System.out.println("setting pressed");
        SettingsForm.getInstance().setVisible(true);
    }

    @FXML
    void toolsButtonPressed() {
        Scene mainMenuScene = this.mainBorderPane.getScene();
        AnchorPane mainMenu = (AnchorPane)mainMenuScene.getRoot();
        try {
            AnchorPane anchorPane = (AnchorPane)FXMLLoader.load((URL)this.getClass().getResource("/fxml/punctuations.fxml"));
            AnchorPane blackAnchor = new AnchorPane();
            blackAnchor.setPrefSize(this.rootAnchor.getWidth(), this.rootAnchor.getHeight());
            blackAnchor.setStyle("-fx-background-color: rgb(0,0,0,0.8)");
            mainMenu.getChildren().add((Object)blackAnchor);
            anchorPane.setLayoutX(this.rootAnchor.getWidth() / 2.0 - 300.0);
            anchorPane.setLayoutY(this.rootAnchor.getHeight() / 2.0 - 250.0);
            mainMenu.getChildren().add((Object)anchorPane);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @FXML
    void sortDescending() {
        this.setting.setProperty("document_sort.order", "descending");
        this.showDocs();
    }

    @FXML
    void sortAscending() {
        this.setting.setProperty("document_sort.order", "ascending");
        this.showDocs();
    }

    @FXML
    void sortByCreationDate() {
        this.setting.setProperty("document_sort.sort_on", "creation_date");
        this.showDocs();
    }

    @FXML
    void sortByEditDate() {
        this.setting.setProperty("document_sort.sort_on", "update_date");
        this.showDocs();
    }

    @FXML
    void sortByTitle() {
        this.setting.setProperty("document_sort.sort_on", "title");
        this.showDocs();
    }

    @FXML
    void update(javafx.event.ActionEvent event) {
        Task task = new Task(){

            protected Object call() throws Exception {
                try {
                    MainPageController.this.doActionHelper.downloadWithoutAuth("resources/hashes.txt", "resources/hashes.txt");
                    FileInputStream myReader = new FileInputStream("resources/hashes.txt");
                    HashMap<String, String> fileHashServer = new HashMap<String, String>();
                    Scanner scanner = new Scanner(myReader);
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine();
                        fileHashServer.put(line.split("\\\\")[0], line.split("\\\\")[1]);
                    }
                    scanner.close();
                    myReader.close();
                    File file = new File("updater.jar");
                    MessageDigest md5Digest = MessageDigest.getInstance("MD5");
                    String checksum = Utilities.getFileChecksum(md5Digest, file);
                    if (!((String)fileHashServer.get("updater.jar")).equals(checksum)) {
                        MainPageController.this.doActionHelper.downloadWithoutAuth("updater.jar", "updater.jar");
                    }
                    if (file.exists()) {
                        System.out.println("exist....");
                    }
                    Thread.sleep(300L);
                    Process proc = Runtime.getRuntime().exec("java -jar updater.jar");
                    System.out.println("path: " + new File(".").getCanonicalPath());
                    System.exit(0);
                }
                catch (IOException e) {
                    System.out.println("not run jar file");
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0639\u062f\u0645 \u0627\u0645\u06a9\u0627\u0646 \u0628\u0631\u0648\u0632 \u0631\u0633\u0627\u0646\u06cc", "\u0627\u062c\u0631\u0627\u06cc \u0628\u0631\u0646\u0627\u0645\u0647 \u0628\u0631\u0648\u0632 \u0631\u0633\u0627\u0646\u06cc \u0628\u0627 \u0645\u0634\u06a9\u0644 \u0645\u0648\u0627\u062c\u0647 \u0634\u062f.", Notifications.INFORMATION);
                            tray.showAndDismiss();
                        }
                    });
                    e.printStackTrace();
                }
                return null;
            }
        };
        this.runATask((Task<Void>)task);
    }

    @FXML
    void openProfilePage(MouseEvent event) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Scene mainMenuScene = MainPageController.this.mainBorderPane.getScene();
                AnchorPane mainMenu = (AnchorPane)mainMenuScene.getRoot();
                try {
                    AnchorPane anchorPane = (AnchorPane)FXMLLoader.load((URL)this.getClass().getResource("/fxml/profile.fxml"));
                    AnchorPane blackAnchor = new AnchorPane();
                    blackAnchor.setPrefSize(MainPageController.this.rootAnchor.getWidth(), MainPageController.this.rootAnchor.getHeight());
                    blackAnchor.setStyle("-fx-background-color: rgb(0,0,0,0.8)");
                    mainMenu.getChildren().add((Object)blackAnchor);
                    anchorPane.setLayoutX(MainPageController.this.rootAnchor.getWidth() / 2.0 - 300.0);
                    anchorPane.setLayoutY(MainPageController.this.rootAnchor.getHeight() / 2.0 - 250.0);
                    mainMenu.getChildren().add((Object)anchorPane);
                }
                catch (IOException e) {
                    Sentry.captureException((Throwable)e);
                    e.printStackTrace();
                }
            }
        });
    }

    @FXML
    void subscriptionStatus(MouseEvent event) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Scene mainMenuScene = MainPageController.this.mainBorderPane.getScene();
                AnchorPane mainMenu = (AnchorPane)mainMenuScene.getRoot();
                try {
                    FXMLLoader fxmlLoader = new FXMLLoader();
                    fxmlLoader.setLocation(this.getClass().getResource("/fxml/plan.fxml"));
                    PlanController planController = new PlanController(MainPageController.this.rootAnchor);
                    fxmlLoader.setController((Object)planController);
                    fxmlLoader.load();
                    AnchorPane anchorPane = (AnchorPane)fxmlLoader.getRoot();
                    AnchorPane blackAnchor = new AnchorPane();
                    blackAnchor.setPrefSize(MainPageController.this.rootAnchor.getWidth(), MainPageController.this.rootAnchor.getHeight());
                    blackAnchor.setStyle("-fx-background-color: rgb(0,0,0,0.8)");
                    mainMenu.getChildren().add((Object)blackAnchor);
                    anchorPane.setLayoutX(MainPageController.this.rootAnchor.getWidth() / 2.0 - 300.0);
                    anchorPane.setLayoutY(MainPageController.this.rootAnchor.getHeight() / 2.0 - 250.0);
                    mainMenu.getChildren().add((Object)anchorPane);
                }
                catch (IOException e) {
                    Sentry.captureException((Throwable)e);
                    e.printStackTrace();
                }
            }
        });
    }

    @FXML
    void showArchive() {
        for (int i = 0; i < this.closableBar.getChildren().size(); ++i) {
            ((ClosableTag)((Object)this.closableBar.getChildren().get(i))).normalMode();
            this.selectedLabels.clear();
        }
        page = Page.ARCHIVE;
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                MainPageController.this.documents = Document.getAll(MainPageController.this.userInfo.getUser_id(), MainPageController.this.setting.getStringProperty("document_sort.sort_on"), MainPageController.this.setting.getStringProperty("document_sort.order"), page);
                MainPageController.this.fillGridPaneWithArrayOfDocument(MainPageController.this.documents);
                return null;
            }
        };
        this.runATask(task);
        this.recognizedWhichPage();
    }

    @FXML
    void showDeleted() {
        for (int i = 0; i < this.closableBar.getChildren().size(); ++i) {
            ((ClosableTag)((Object)this.closableBar.getChildren().get(i))).normalMode();
            this.selectedLabels.clear();
        }
        page = Page.TRASH;
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                MainPageController.this.documents = Document.getAll(MainPageController.this.userInfo.getUser_id(), MainPageController.this.setting.getStringProperty("document_sort.sort_on"), MainPageController.this.setting.getStringProperty("document_sort.order"), page);
                MainPageController.this.fillGridPaneWithArrayOfDocument(MainPageController.this.documents);
                return null;
            }
        };
        this.runATask(task);
        this.recognizedWhichPage();
    }

    @FXML
    void showAllDocs() {
        for (int i = 0; i < this.closableBar.getChildren().size(); ++i) {
            ((ClosableTag)((Object)this.closableBar.getChildren().get(i))).normalMode();
            this.selectedLabels.clear();
        }
        page = Page.NORMAL;
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                MainPageController.this.documents = Document.getAll(MainPageController.this.userInfo.getUser_id(), MainPageController.this.setting.getStringProperty("document_sort.sort_on"), MainPageController.this.setting.getStringProperty("document_sort.order"), page);
                MainPageController.this.fillGridPaneWithArrayOfDocument(MainPageController.this.documents);
                return null;
            }
        };
        this.runATask(task);
        this.recognizedWhichPage();
    }

    @FXML
    void searchFieldClicked(MouseEvent event) {
        this.searchBtn.setStyle("-fx-background-color: rgba(35, 132, 196, 0.5);");
    }

    @FXML
    void removeBackGroundOfSearchBtn(MouseEvent event) {
        this.searchBtn.setStyle("-fx-background-color: rgba(0,0,0,0);");
    }

    @FXML
    void sync(javafx.event.ActionEvent event) {
        this.selectedLabels.clear();
        this.syncImageView.setImage(syncGif);
        Task task = new Task(){

            protected Object call() throws Exception {
                MainPageController.this.userInfo.coordinationDbWithServer();
                return null;
            }
        };
        this.runSyncingTask(task);
    }

    private void runSyncingTask(final Task task) {
        task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                MainPageController.this.syncImageView.setImage(syncImage);
                MainPageController.this.loadNewInfo();
                MainPageController.this.syncingLabel.setVisible(true);
                MainPageController.this.fadeSyncLabel.playFromStart();
            }
        });
        task.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                Sentry.captureException((Throwable)task.getException());
                MainPageController.this.syncImageView.setImage(syncImage);
                TrayNotification tray = new TrayNotification("\u0639\u062f\u0645 \u0628\u0627\u0632\u0646\u0634\u0627\u0646\u06cc", "\u0628\u0627\u0632\u0646\u0634\u0627\u0646\u06cc \u0627\u0637\u0644\u0627\u0639\u0627\u062a \u0627\u0646\u062c\u0627\u0645 \u0646\u0634\u062f.", Notifications.NOTICE);
                tray.showAndDismiss();
            }
        });
        task.setOnCancelled((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                MainPageController.this.syncImageView.setImage(syncImage);
                TrayNotification tray = new TrayNotification("\u0639\u062f\u0645 \u0628\u0627\u0632\u0646\u0634\u0627\u0646\u06cc", "\u0628\u0627\u0632\u0646\u0634\u0627\u0646\u06cc \u0627\u0637\u0644\u0627\u0639\u0627\u062a \u0627\u0646\u062c\u0627\u0645 \u0646\u0634\u062f.", Notifications.NOTICE);
                tray.showAndDismiss();
            }
        });
        Thread thread = new Thread((Runnable)task);
        thread.setDaemon(true);
        thread.start();
    }

    private void loadNewInfo() {
        this.showDocs();
        this.addTags();
    }
}

