/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXPasswordField;
import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.controls.JFXTextField;
import io.sentry.Sentry;
import ir.deepmine.dictation.Main;
import ir.deepmine.dictation.controller.ResizeHelper;
import ir.deepmine.dictation.database.UserData;
import ir.deepmine.dictation.exceptions.ConnectionException;
import ir.deepmine.dictation.exceptions.ExceptionHandling;
import ir.deepmine.dictation.exceptions.GeneralException;
import ir.deepmine.dictation.exceptions.InvalidDataException;
import ir.deepmine.dictation.exceptions.InvalidTokenException;
import ir.deepmine.dictation.exceptions.ServerException;
import ir.deepmine.dictation.exceptions.UserNotFoundException;
import ir.deepmine.dictation.ui.TitleBar;
import ir.deepmine.dictation.ui.notification.Notifications;
import ir.deepmine.dictation.ui.notification.TrayNotification;
import ir.deepmine.dictation.utils.DoActions;
import ir.deepmine.dictation.utils.UserInfo;
import ir.deepmine.dictation.utils.Utilities;
import java.io.IOException;
import java.util.HashMap;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Duration;
import javax.swing.JFrame;

public class LoginController {
    private static boolean visible;
    private static JFrame frame;
    private static String passwordText;
    Task coordinationTask;
    @FXML
    private JFXButton enterButton;
    @FXML
    private JFXCheckBox rememberMe;
    @FXML
    private JFXButton registerButton;
    @FXML
    private JFXTextField passwordTextField;
    @FXML
    private JFXButton forgetting;
    @FXML
    private JFXTextField userNameField;
    @FXML
    private JFXPasswordField passwordField;
    @FXML
    private ImageView visibility;
    @FXML
    private BorderPane pane;
    @FXML
    private Label invalidFormatLabel;
    @FXML
    private JFXProgressBar progressBar;
    private FadeTransition fadeTransition;
    private UserData userData;
    private UserInfo userInfo;
    private DoActions doActions;
    private ExceptionHandling exceptionHandling;

    public static JFrame getFrame() {
        return frame;
    }

    public void initialize() {
        this.createTask();
        this.doActions = DoActions.getInstance();
        this.userInfo = UserInfo.getInstance();
        this.exceptionHandling = ExceptionHandling.getInstance();
        this.userData = UserData.get();
        TitleBar titleBar = TitleBar.getInstance("normal");
        titleBar.visibleLaunch(false);
        this.pane.setTop((Node)titleBar);
        passwordText = "";
        visible = false;
        this.passwordTextField.setVisible(false);
        this.bind();
        this.progressBar.setVisible(false);
        if (this.userData != null) {
            if (this.userData.getRefresh() != null && this.userData.getAccess() != null) {
                this.rememberMe.setSelected(true);
                this.rememberMe.applyCss();
            }
            this.userNameField.setText(this.userData.getUserName());
        }
        this.fadeTransition = new FadeTransition(Duration.millis((double)7000.0), (Node)this.invalidFormatLabel);
        this.fadeTransition.setFromValue(1.0);
        this.fadeTransition.setToValue(0.0);
    }

    private void createTask() {
        this.coordinationTask = new Task(){

            protected Object call() throws Exception {
                LoginController.this.userInfo.initializeBasic();
                return null;
            }
        };
        this.coordinationTask.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LoginController.this.showMainPage();
                    }
                });
            }
        });
        this.coordinationTask.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                Sentry.captureException((Throwable)LoginController.this.coordinationTask.getException());
                System.out.println("fail");
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LoginController.this.coordinationTask.getException().printStackTrace();
                        TrayNotification tray = new TrayNotification("\u062e\u0637\u0627 \u062f\u0631 \u0639\u0645\u0644\u06cc\u0627\u062a", "\u0639\u0645\u0644\u06cc\u0627\u062a \u0628\u0647 \u062f\u0631\u0633\u062a\u06cc \u0627\u0646\u062c\u0627\u0645 \u0646\u0634\u062f.", Notifications.WARNING);
                        tray.showAndDismiss();
                        LoginController.this.showMainPage();
                    }
                });
            }
        });
    }

    private void reDoLogin() {
        this.createTask();
        this.bind();
        this.progressBar.setVisible(false);
        if (this.userData != null) {
            if (this.userData.getRefresh() != null && this.userData.getAccess() != null) {
                this.rememberMe.setSelected(true);
            }
            this.userNameField.setText(this.userData.getUserName());
        }
    }

    private void bind() {
        this.enterButton.disableProperty().bind((ObservableValue)this.coordinationTask.stateProperty().isNotEqualTo((Object)Worker.State.READY));
        this.forgetting.disableProperty().bind((ObservableValue)this.coordinationTask.stateProperty().isNotEqualTo((Object)Worker.State.READY));
        this.rememberMe.disableProperty().bind((ObservableValue)this.coordinationTask.stateProperty().isNotEqualTo((Object)Worker.State.READY));
        this.registerButton.disableProperty().bind((ObservableValue)this.coordinationTask.stateProperty().isNotEqualTo((Object)Worker.State.READY));
        this.progressBar.progressProperty().bind((ObservableValue)this.userInfo.progressProperty());
    }

    @FXML
    void enterPane(MouseEvent event) {
        this.enterButton.getScene().setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ENTER) {
                    LoginController.this.enterButton.fire();
                }
            }
        });
    }

    @FXML
    void changeVisibility(MouseEvent event) {
        if (!visible) {
            visible = true;
            this.visibility.setImage(new Image(String.valueOf(Main.class.getResource("/icons/unvisibility.png"))));
            this.passwordTextField.setVisible(true);
            this.passwordTextField.setText(this.passwordField.getText());
            this.passwordField.setVisible(false);
        } else {
            visible = false;
            this.visibility.setImage(new Image(String.valueOf(Main.class.getResource("/icons/visibility.png"))));
            this.passwordField.setVisible(true);
            this.passwordField.setText(this.passwordTextField.getText());
            this.passwordTextField.setVisible(false);
        }
    }

    @FXML
    void enterClick(ActionEvent event) {
        String username = "";
        String password = "";
        boolean correctFormat = true;
        password = visible ? this.passwordTextField.getText() : this.passwordField.getText();
        username = this.userNameField.getText();
        if (!Utilities.validateEmail(username) && !Utilities.validatePhoneNumber(username)) {
            correctFormat = false;
        }
        if (correctFormat) {
            HashMap<String, String> info = null;
            try {
                info = this.doActions.login(this.userNameField.getText(), password);
                this.login();
            }
            catch (ConnectionException e) {
                this.exceptionHandling.connectionExceptionHandling(e);
            }
            catch (UserNotFoundException e) {
                TrayNotification tray = new TrayNotification(e.getMessage(), Notifications.WARNING);
                tray.showAndDismiss();
            }
            catch (GeneralException e) {
                this.exceptionHandling.generalExceptionHandling(e);
            }
            catch (InvalidTokenException e) {
                this.exceptionHandling.invalidTokenExceptionHandling(e);
            }
            catch (InvalidDataException e) {
                this.invalidFormatLabel.setVisible(true);
                this.fadeTransition.playFromStart();
            }
            catch (ServerException e) {
                this.exceptionHandling.serverExceptionHandling(e);
            }
        } else {
            this.invalidFormatLabel.setVisible(true);
            this.fadeTransition.playFromStart();
        }
    }

    private void login() {
        this.progressBar.setVisible(true);
        if (this.userData == null) {
            this.userData = new UserData();
        }
        if (this.rememberMe.isSelected()) {
            this.userData.setAccess(this.userInfo.getAccess());
            this.userData.setRefresh(this.userInfo.getRefresh());
            this.userData.setUserId(this.userInfo.getUser_id());
        } else {
            this.userData.setRefresh(null);
            this.userData.setAccess(null);
            this.userData.setUserId(0L);
        }
        this.userData.setUserName(this.userNameField.getText());
        UserData.put(this.userData);
        this.userNameField.setFocusTraversable(false);
        this.passwordField.setFocusTraversable(false);
        this.passwordTextField.setFocusTraversable(false);
        this.runTask(this.coordinationTask);
    }

    private void runTask(Task task) {
        Thread backgroundThread = new Thread((Runnable)task);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void showMainPage() {
        System.setProperty("prism.lcdtext", "false");
        Stage stage = (Stage)this.enterButton.getScene().getWindow();
        stage.getIcons().add((Object)Utilities.icon);
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/main-page.fxml"));
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        Parent root = (Parent)fxmlLoader.getRoot();
        Scene scene = new Scene(root);
        stage.setScene(scene);
        stage.setResizable(true);
        ResizeHelper.addResizeListener(stage, 960.0, 564.0, Double.MAX_VALUE, Double.MAX_VALUE);
        stage.show();
    }

    @FXML
    void forgettingClick(ActionEvent event) {
        System.setProperty("prism.lcdtext", "false");
        Stage stage = (Stage)this.enterButton.getScene().getWindow();
        stage.getIcons().add((Object)Utilities.icon);
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/forget-password.fxml"));
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        Parent root = (Parent)fxmlLoader.getRoot();
        Scene scene = new Scene(root);
        stage.setScene(scene);
        stage.setResizable(true);
        ResizeHelper.addResizeListener(stage, 960.0, 564.0, Double.MAX_VALUE, Double.MAX_VALUE);
        stage.show();
    }

    @FXML
    void registerClick(ActionEvent event) {
        System.setProperty("prism.lcdtext", "false");
        Stage stage = (Stage)this.enterButton.getScene().getWindow();
        stage.getIcons().add((Object)Utilities.icon);
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/register.fxml"));
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        Parent root = (Parent)fxmlLoader.getRoot();
        Scene scene = new Scene(root);
        stage.setScene(scene);
        stage.setResizable(true);
        ResizeHelper.addResizeListener(stage, 960.0, 564.0, Double.MAX_VALUE, Double.MAX_VALUE);
        stage.show();
    }

    static {
        frame = null;
    }
}

