/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller.EditorPageControllers;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.controls.JFXTextArea;
import io.sentry.Sentry;
import ir.deepmine.dictation.controller.EditorPageControllers.EditorPageController;
import ir.deepmine.dictation.ui.HTMLEditor.HTMLEditor;
import ir.deepmine.dictation.ui.HTMLEditor.HTMLEditorSkin;
import ir.deepmine.dictation.ui.notification.Notification;
import ir.deepmine.dictation.ui.notification.Notifications;
import ir.deepmine.dictation.ui.notification.TrayNotification;
import ir.deepmine.dictation.utils.Formatter;
import ir.deepmine.dictation.utils.GrpcClient;
import ir.deepmine.dictation.utils.PunctuationsProcessing;
import ir.deepmine.dictation.utils.Settings;
import ir.deepmine.dictation.utils.Utilities;
import java.awt.AWTException;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.swing.Timer;

public class FileToTextPopupController {
    private static final Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private static float lastWordEndTimeGet = 1.0f;
    private static float lastWordEndTimeSend = 1.0f;
    private final Settings settings = Settings.getInstance();
    private final GrpcClient client;
    private final ResultObserver resultObserver;
    private final Object lock = new Object();
    private int state = 0;
    private Robot robot;
    private boolean lastCharacterWasSpace = true;
    private RecognizingTask recognizingTask = null;
    private Thread recognizingThread = null;
    private HTMLEditor htmlEditor;
    private AnchorPane rootAnchor;
    private HTMLEditorSkin skin;
    private Timer timer;
    private String initial;
    private String fileN;
    private double anchorX;
    private double anchorY;
    private double lastX;
    private double lastY;
    private boolean exit;
    private long curWorkTime;
    private float fileDuration = 1.0f;
    @FXML
    private JFXButton cancel;
    @FXML
    private JFXButton pauseOrResume;
    @FXML
    private Label fileName;
    @FXML
    private JFXProgressBar progressBar;
    @FXML
    private Label percentLabel;
    @FXML
    private JFXTextArea textArea;
    @FXML
    private Label currentTime;
    @FXML
    private Label fullTime;
    private String filePath;

    public FileToTextPopupController(HTMLEditor htmlEditor, AnchorPane rootAnchor, String fileN) {
        this.resultObserver = new ResultObserver();
        this.client = new GrpcClient("accessToken", 16000, this.settings.getStringProperty("grpc.language_code"), this.settings.getStringProperty("grpc.model_name"), this.resultObserver);
        this.htmlEditor = htmlEditor;
        this.rootAnchor = rootAnchor;
        this.initial = htmlEditor.getHtmlText();
        this.fileN = fileN;
    }

    public void initialize() {
        final File selectedFile = EditorPageController.selectedFile;
        if (!selectedFile.exists()) {
            this.showPopup("\u0639\u062f\u0645 \u0648\u062c\u0648\u062f \u0641\u0627\u06cc\u0644", "\u0641\u0627\u06cc\u0644 \u0627\u0646\u062a\u062e\u0627\u0628 \u0634\u062f\u0647 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.", Notifications.ERROR, false);
            return;
        }
        Task task = new Task(){

            protected Object call() throws Exception {
                FileToTextPopupController.this.filePath = Utilities.convertFile(selectedFile.getAbsolutePath());
                if (FileToTextPopupController.this.filePath == null) {
                    FileToTextPopupController.this.showPopup("\u062a\u0628\u062f\u06cc\u0644 \u0641\u0627\u06cc\u0644 \u0627\u0646\u062a\u062e\u0627\u0628\u06cc", "\u0627\u0645\u06a9\u0627\u0646 \u062a\u0628\u062f\u06cc\u0644 \u0627\u06cc\u0646 \u0641\u0627\u06cc\u0644 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.", Notifications.ERROR, false);
                    throw new Exception("Convert File to wav was failed");
                }
                return null;
            }
        };
        this.runATask(task);
        this.textArea.setEditable(false);
        this.pauseOrResume.setText("\u062a\u0648\u0642\u0641");
        this.fileName.setText(this.fileN);
        this.state = 1;
        this.skin = (HTMLEditorSkin)this.htmlEditor.getSkin();
        this.skin.getWebView().requestFocus();
        try {
            this.robot = new Robot();
        }
        catch (AWTException e) {
            Platform.runLater(() -> {
                TrayNotification tray = new TrayNotification("\u0639\u062f\u0645 \u062f\u0633\u062a\u0631\u0633\u06cc", "\u0627\u0645\u06a9\u0627\u0646 \u062f\u0633\u062a\u0631\u0633\u06cc \u0628\u0647 \u0639\u0645\u0644\u06cc\u0627\u062a \u06a9\u06cc\u0628\u0648\u0631\u062f \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.", Notifications.INFORMATION);
                tray.showAndDismiss();
            });
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
    }

    @FXML
    void cancelClick(javafx.event.ActionEvent event) {
        this.exit = true;
        lastWordEndTimeGet = 0.0f;
        if (this.recognizingTask != null && this.recognizingTask.isRunning()) {
            this.recognizingTask.resume();
        }
        this.rootAnchor.getChildren().remove(this.rootAnchor.getChildren().size() - 1);
        this.rootAnchor.getChildren().remove(this.rootAnchor.getChildren().size() - 1);
    }

    @FXML
    void pauseOrResumeClick(javafx.event.ActionEvent event) {
        if (this.state == 1) {
            this.state = 2;
            this.timer.stop();
            this.progressBar.setDisable(true);
            this.recognizingTask.pause();
            this.pauseOrResume.setText("\u0627\u062f\u0627\u0645\u0647");
        } else if (this.state == 2) {
            this.state = 1;
            this.timer.restart();
            this.progressBar.setDisable(false);
            this.recognizingTask.resume();
            this.pauseOrResume.setText("\u062a\u0648\u0642\u0641");
        }
    }

    @FXML
    void rootAnchorDrag(MouseEvent event) {
        Stage stage = (Stage)this.textArea.getScene().getWindow();
        stage.setX(event.getScreenX() - this.anchorX);
        stage.setY(event.getScreenY() - this.anchorY);
    }

    @FXML
    void rootAnchorPress(MouseEvent event) {
        this.anchorX = event.getSceneX();
        this.anchorY = event.getSceneY();
    }

    @FXML
    void rootDragDetected(MouseEvent event) {
        Window w = this.textArea.getScene().getWindow();
        this.lastX = w.getX();
        this.lastY = w.getY();
    }

    private void runATask(Task task) {
        task.setOnSucceeded(event -> {
            System.out.println("success : " + this.filePath);
            this.recognizingTask = new RecognizingTask(this.filePath);
            this.recognizingThread = new Thread((Runnable)((Object)this.recognizingTask));
            this.recognizingThread.setDaemon(true);
            this.startTimer();
            this.recognizingThread.start();
        });
        task.setOnCancelled(event -> System.out.println("cancel"));
        task.setOnFailed(event -> {
            task.getException().printStackTrace();
            Sentry.captureException((Throwable)task.getException());
            System.out.println("failed");
        });
        Thread th = new Thread((Runnable)task);
        th.setDaemon(true);
        th.start();
    }

    private void showPopup(final String title, final String text, final Notification type, final boolean stable) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!stable) {
                    FileToTextPopupController.this.rootAnchor.getChildren().remove(FileToTextPopupController.this.rootAnchor.getChildren().size() - 1);
                    FileToTextPopupController.this.rootAnchor.getChildren().remove(FileToTextPopupController.this.rootAnchor.getChildren().size() - 1);
                }
                TrayNotification tray = new TrayNotification(title, text, type);
                tray.showAndDismiss();
            }
        });
    }

    private String getTime(float time) {
        Object res = "";
        int hour = 0;
        int min = 0;
        int second = 0;
        hour = (int)(time / 3600.0f);
        min = (int)((time %= 3600.0f) / 60.0f);
        second = (int)(time %= 60.0f) % 60;
        res = (String)res + hour;
        if (hour < 10) {
            res = "0" + hour;
        }
        res = min < 10 ? (String)res + ":0" + min : (String)res + ":" + min;
        res = second < 10 ? (String)res + ":0" + second : (String)res + ":" + second;
        return res;
    }

    void setFullTimeLabel(float time) {
        final String res = this.getTime(time);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FileToTextPopupController.this.fullTime.setText(res);
                System.out.println("set time");
            }
        });
    }

    void startTimer() {
        this.timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final String res = FileToTextPopupController.this.getTime(FileToTextPopupController.this.curWorkTime);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FileToTextPopupController.this.currentTime.setText(res);
                    }
                });
                FileToTextPopupController.this.curWorkTime++;
            }
        });
        this.timer.start();
    }

    private class RecognizingTask
    extends Task<Void> {
        private final String filePath;
        volatile boolean shouldHalt = false;

        public RecognizingTask(String filePath) {
            this.filePath = filePath;
        }

        protected Void call() throws IOException {
            File fid = new File(this.filePath);
            int chunkSize = 131072;
            int offset = 0;
            int fileSize = (int)fid.length();
            try (RandomAccessFile fReader = new RandomAccessFile(fid, "r");){
                FileToTextPopupController.this.client.start();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (fileSize < 44) {
                    Void e = null;
                    return e;
                }
                fReader.seek(44L);
                FileToTextPopupController.this.fileDuration = (float)(fileSize -= 44) / 32000.0f;
                FileToTextPopupController.this.setFullTimeLabel(FileToTextPopupController.this.fileDuration);
                byte[] buffer = new byte[chunkSize];
                while (!FileToTextPopupController.this.exit) {
                    int size;
                    if (this.isCancelled()) {
                        this.updateMessage("Cancelled");
                        break;
                    }
                    if (this.shouldHalt) {
                        this.halt();
                    }
                    if (offset + (size = chunkSize) > fileSize) {
                        size = fileSize - offset;
                    }
                    fReader.read(buffer, 0, size);
                    FileToTextPopupController.this.client.processNextBuffer(buffer, 0, size);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.println("Offset " + offset + " / " + fileSize);
                    System.out.println("last: " + lastWordEndTimeGet + ", offset: " + offset / 32000);
                    this.updateMessage("Offset " + offset);
                    this.updateProgress(offset += size, fileSize);
                    if (offset < fileSize) continue;
                    break;
                }
                FileToTextPopupController.this.client.finish();
                Void void_ = null;
                return void_;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void halt() {
            try {
                Object object = FileToTextPopupController.this.lock;
                synchronized (object) {
                    FileToTextPopupController.this.lock.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void pause() {
            this.shouldHalt = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            this.shouldHalt = false;
            try {
                Object object = FileToTextPopupController.this.lock;
                synchronized (object) {
                    FileToTextPopupController.this.lock.notifyAll();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            this.resume();
            return super.cancel(mayInterruptIfRunning);
        }
    }

    private class ResultObserver
    implements GrpcClient.ResultObserver {
        private String partialStableResult = "";
        private final PunctuationsProcessing punctuationsProcessing = PunctuationsProcessing.getInstance();

        private ResultObserver() {
        }

        @Override
        public void onNext(String stableResult, String nonStableResult, boolean isFinal, float lastWordEndTime) {
            if (isFinal) {
                if (((String)stableResult).isEmpty()) {
                    return;
                }
                lastWordEndTimeGet = lastWordEndTime;
                System.out.println("last: " + lastWordEndTime);
                if (Formatter.isSafeToFinalize((String)stableResult)) {
                    if (!this.partialStableResult.isEmpty()) {
                        stableResult = ((String)stableResult).charAt(0) == ' ' || this.partialStableResult.endsWith(" ") ? this.partialStableResult + (String)stableResult : this.partialStableResult + " " + (String)stableResult;
                        this.partialStableResult = "";
                    }
                    stableResult = Formatter.apply((String)stableResult, FileToTextPopupController.this.settings.getBooleanProperty("process.apply_punctuation"), FileToTextPopupController.this.settings.getBooleanProperty("process.apply_numbers"), FileToTextPopupController.this.settings.getBooleanProperty("process.apply_datetime"), FileToTextPopupController.this.settings.getBooleanProperty("process.apply_phone_numbers"), FileToTextPopupController.this.settings.getBooleanProperty("process.type_to_word"), FileToTextPopupController.this.settings.getStringProperty("process.date_separator").charAt(0));
                    String extraSpace = "";
                    if (!FileToTextPopupController.this.lastCharacterWasSpace && ((String)stableResult).charAt(0) != ' ' && this.punctuationsProcessing.isSpaceNeededBeforeCharacter(Character.valueOf(((String)stableResult).charAt(0)))) {
                        extraSpace = " ";
                    }
                    FileToTextPopupController.this.lastCharacterWasSpace = ((String)stableResult).endsWith(" ") || ((String)stableResult).endsWith("\n") || !this.punctuationsProcessing.isSpaceNeededAfterCharacter(Character.valueOf(((String)stableResult).charAt(((String)stableResult).length() - 1)));
                    Object finalStableResult = stableResult;
                    Platform.runLater(() -> this.lambda$onNext$0((String)finalStableResult, lastWordEndTime));
                } else {
                    this.partialStableResult = !this.partialStableResult.isEmpty() ? (((String)stableResult).charAt(0) == ' ' || this.partialStableResult.endsWith(" ") ? this.partialStableResult + (String)stableResult : this.partialStableResult + " " + (String)stableResult) : stableResult;
                }
            } else {
                if (!this.partialStableResult.isEmpty()) {
                    stableResult = ((String)stableResult).isEmpty() || ((String)stableResult).charAt(0) == ' ' || this.partialStableResult.endsWith(" ") ? this.partialStableResult + (String)stableResult : this.partialStableResult + " " + (String)stableResult;
                }
                stableResult = ((String)stableResult).endsWith(" ") || nonStableResult.charAt(0) == ' ' ? (String)stableResult + nonStableResult : (String)stableResult + " " + nonStableResult;
                FileToTextPopupController.this.textArea.setText((String)stableResult);
            }
        }

        @Override
        public void onError(Throwable t) {
            if (t instanceof RuntimeException) {
                FileToTextPopupController.this.showPopup("\u0642\u0637\u0639\u06cc \u0627\u0631\u062a\u0628\u0627\u0637", "\u0627\u062a\u0635\u0627\u0644 \u0627\u06cc\u0646\u062a\u0631\u0646\u062a \u062e\u0648\u062f \u0631\u0627 \u0628\u0631\u0631\u0633\u06cc \u06a9\u0646\u06cc\u062f.", Notifications.ERROR, true);
            }
            System.out.println("onError");
            t.printStackTrace();
            Platform.runLater(() -> {
                if (FileToTextPopupController.this.recognizingTask != null && FileToTextPopupController.this.recognizingTask.isRunning()) {
                    FileToTextPopupController.this.recognizingTask.cancel(true);
                }
                FileToTextPopupController.this.pauseOrResume.setText("\u0634\u0631\u0648\u0639");
                FileToTextPopupController.this.timer.stop();
                FileToTextPopupController.this.state = 0;
            });
        }

        @Override
        public void onCompleted() {
            System.out.println("onCompleted");
            Platform.runLater(() -> {
                if (FileToTextPopupController.this.recognizingTask != null && FileToTextPopupController.this.recognizingTask.isRunning()) {
                    FileToTextPopupController.this.recognizingTask.cancel(true);
                }
                FileToTextPopupController.this.timer.stop();
                FileToTextPopupController.this.progressBar.setProgress(1.0);
                FileToTextPopupController.this.percentLabel.setText("100");
                FileToTextPopupController.this.pauseOrResume.setDisable(true);
                FileToTextPopupController.this.pauseOrResume.setVisible(false);
                FileToTextPopupController.this.cancel.setText("\u062a\u0627\u06cc\u06cc\u062f");
                FileToTextPopupController.this.cancel.setRipplerFill(Paint.valueOf((String)"#ccff90"));
                FileToTextPopupController.this.cancel.setTextFill(Paint.valueOf((String)"#ccff90"));
                FileToTextPopupController.this.state = 3;
            });
        }

        private /* synthetic */ void lambda$onNext$0(String finalStableResult, float lastWordEndTime) {
            String finalRes = finalStableResult.replaceAll("\n", "<br>");
            FileToTextPopupController.this.htmlEditor.setHtmlText(FileToTextPopupController.this.htmlEditor.getHtmlText() + finalRes);
            int prog = (int)(lastWordEndTime / FileToTextPopupController.this.fileDuration * 100.0f);
            FileToTextPopupController.this.percentLabel.setText(String.valueOf(prog));
            FileToTextPopupController.this.progressBar.setProgress((double)(lastWordEndTime / FileToTextPopupController.this.fileDuration));
        }
    }
}

