/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation;

import io.sentry.Sentry;
import ir.deepmine.dictation.controller.ResizeHelper;
import ir.deepmine.dictation.controller.enums.UpdateState;
import ir.deepmine.dictation.exceptions.ConnectionException;
import ir.deepmine.dictation.exceptions.ExceptionHandling;
import ir.deepmine.dictation.exceptions.ForceUpdateException;
import ir.deepmine.dictation.exceptions.GeneralException;
import ir.deepmine.dictation.exceptions.InvalidTokenException;
import ir.deepmine.dictation.exceptions.NotExistException;
import ir.deepmine.dictation.exceptions.ServerException;
import ir.deepmine.dictation.exceptions.SoftUpdateException;
import ir.deepmine.dictation.ui.TitleBar;
import ir.deepmine.dictation.ui.notification.Notifications;
import ir.deepmine.dictation.ui.notification.TrayNotification;
import ir.deepmine.dictation.utils.DoActionHelper;
import ir.deepmine.dictation.utils.Settings;
import ir.deepmine.dictation.utils.UserInfo;
import ir.deepmine.dictation.utils.Utilities;
import java.io.IOException;
import java.net.URL;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class Main {
    private static JFrame frame = null;
    private static Settings settings = Settings.getInstance();
    private static ExceptionHandling exceptionHandling = ExceptionHandling.getInstance();
    public static UpdateState updateStatus = UpdateState.SYNC;

    public static void main(String[] args) {
        System.out.println("Starting ...");
        Sentry.init(options -> options.setDsn("https://3602fd97aa2c45bfbe5f8b4075dc9aa9@sentry.deepmine.ir/7"));
        new JFXPanel();
        try {
            DoActionHelper.getInstance().checkExistUpdate(10001);
            updateStatus = UpdateState.SYNC;
        }
        catch (GeneralException e) {
            exceptionHandling.generalExceptionHandling(e);
        }
        catch (ServerException e) {
            exceptionHandling.serverExceptionHandling(e);
        }
        catch (ConnectionException e) {
            exceptionHandling.connectionExceptionHandling(e);
        }
        catch (SoftUpdateException e) {
            updateStatus = UpdateState.SOFT;
        }
        catch (ForceUpdateException e) {
            updateStatus = UpdateState.FORCE;
        }
        if (UserInfo.checkAccess()) {
            if (settings.getStringProperty("app_mode.mode").equals("app_mode.mode")) {
                settings.setProperty("app_mode.mode", "main_page");
            }
            if (settings.getStringProperty("app_mode.mode").equals("main_page") || updateStatus == UpdateState.FORCE) {
                try {
                    UserInfo.getInstance().initializeBasic();
                }
                catch (ConnectionException | GeneralException | InvalidTokenException | NotExistException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u062e\u0637\u0627 \u062f\u0631 \u0639\u0645\u0644\u06cc\u0627\u062a", "\u0628\u0627\u0632\u0646\u0634\u0627\u0646\u06cc \u0627\u0637\u0644\u0627\u0639\u0627\u062a \u0627\u0646\u062c\u0627\u0645 \u0646\u0634\u062f.", Notifications.NOTICE);
                            tray.showAndDismiss();
                            Sentry.captureException((Throwable)e);
                        }
                    });
                }
                catch (ServerException e) {
                    ExceptionHandling.getInstance().serverExceptionHandling(e);
                }
                Main.openMainPage();
            } else {
                Utilities.startWithToolbar = true;
                Main.openToolBar();
            }
        } else {
            Main.openLogin();
        }
    }

    private static void openLogin() {
        Platform.runLater(() -> {
            System.setProperty("prism.lcdtext", "false");
            Stage stage = new Stage();
            stage.getIcons().add((Object)Utilities.icon);
            FXMLLoader fxmlLoader = new FXMLLoader();
            fxmlLoader.setLocation(Main.class.getResource("/fxml/login.fxml"));
            try {
                fxmlLoader.load();
            }
            catch (Exception e) {
                Sentry.captureException((Throwable)e);
                e.printStackTrace();
            }
            Parent root = (Parent)fxmlLoader.getRoot();
            Scene scene = new Scene(root);
            stage.setScene(scene);
            stage.setResizable(true);
            ResizeHelper.addResizeListener(stage, 960.0, 564.0, Double.MAX_VALUE, Double.MAX_VALUE);
            stage.initStyle(StageStyle.UNDECORATED);
            stage.show();
        });
    }

    private static void openMainPage() {
        Platform.runLater(() -> {
            System.setProperty("prism.lcdtext", "false");
            Stage stage = new Stage();
            stage.getIcons().add((Object)Utilities.icon);
            FXMLLoader fxmlLoader = new FXMLLoader();
            fxmlLoader.setLocation(Main.class.getResource("/fxml/main-page.fxml"));
            try {
                fxmlLoader.load();
            }
            catch (IOException e) {
                Sentry.captureException((Throwable)e);
                e.printStackTrace();
            }
            Parent root = (Parent)fxmlLoader.getRoot();
            Scene scene = new Scene(root);
            stage.setScene(scene);
            stage.setResizable(true);
            ResizeHelper.addResizeListener(stage, 960.0, 564.0, Double.MAX_VALUE, Double.MAX_VALUE);
            stage.initStyle(StageStyle.UNDECORATED);
            stage.show();
        });
    }

    private static void openToolBar() {
        SwingUtilities.invokeLater(() -> {
            new JFXPanel();
            Platform.runLater(() -> {
                TitleBar.frame = null;
                URL fxmlUrl = Main.class.getResource("/fxml/toolbarWithSetting.fxml");
                if (fxmlUrl == null) {
                    System.out.println("File not found.");
                    Platform.exit();
                    return;
                }
                Parent root = null;
                System.setProperty("prism.lcdtext", "false");
                try {
                    root = (Parent)FXMLLoader.load((URL)fxmlUrl);
                }
                catch (IOException e) {
                    Sentry.captureException((Throwable)e);
                    e.printStackTrace();
                }
                Scene scene = new Scene(root);
                scene.setFill((Paint)Color.TRANSPARENT);
                TitleBar.frame = new TitleBar.MainFrame(scene);
                TitleBar.frame.setVisible(true);
                TitleBar.frame.toFront();
            });
        });
    }

    public static JFrame getFrame() {
        return frame;
    }
}

